/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1TopologySelectorTerm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.  StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.")
public class V1StorageClass
implements KubernetesObject {
    public static final String SERIALIZED_NAME_ALLOW_VOLUME_EXPANSION = "allowVolumeExpansion";
    @SerializedName(value="allowVolumeExpansion")
    private Boolean allowVolumeExpansion;
    public static final String SERIALIZED_NAME_ALLOWED_TOPOLOGIES = "allowedTopologies";
    @SerializedName(value="allowedTopologies")
    private List<V1TopologySelectorTerm> allowedTopologies = null;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_MOUNT_OPTIONS = "mountOptions";
    @SerializedName(value="mountOptions")
    private List<String> mountOptions = null;
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private Map<String, String> parameters = null;
    public static final String SERIALIZED_NAME_PROVISIONER = "provisioner";
    @SerializedName(value="provisioner")
    private String provisioner;
    public static final String SERIALIZED_NAME_RECLAIM_POLICY = "reclaimPolicy";
    @SerializedName(value="reclaimPolicy")
    private String reclaimPolicy;
    public static final String SERIALIZED_NAME_VOLUME_BINDING_MODE = "volumeBindingMode";
    @SerializedName(value="volumeBindingMode")
    private String volumeBindingMode;

    public V1StorageClass allowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allowVolumeExpansion shows whether the storage class allow volume expand.")
    public Boolean getAllowVolumeExpansion() {
        return this.allowVolumeExpansion;
    }

    public void setAllowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
    }

    public V1StorageClass allowedTopologies(List<V1TopologySelectorTerm> allowedTopologies) {
        this.allowedTopologies = allowedTopologies;
        return this;
    }

    public V1StorageClass addAllowedTopologiesItem(V1TopologySelectorTerm allowedTopologiesItem) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<V1TopologySelectorTerm>();
        }
        this.allowedTopologies.add(allowedTopologiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allowedTopologies restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.")
    public List<V1TopologySelectorTerm> getAllowedTopologies() {
        return this.allowedTopologies;
    }

    public void setAllowedTopologies(List<V1TopologySelectorTerm> allowedTopologies) {
        this.allowedTopologies = allowedTopologies;
    }

    public V1StorageClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1StorageClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1StorageClass metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1StorageClass mountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public V1StorageClass addMountOptionsItem(String mountOptionsItem) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(mountOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="mountOptions controls the mountOptions for dynamically provisioned PersistentVolumes of this storage class. e.g. [\"ro\", \"soft\"]. Not validated - mount of the PVs will simply fail if one is invalid.")
    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    public void setMountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
    }

    public V1StorageClass parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public V1StorageClass putParametersItem(String key, String parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="parameters holds the parameters for the provisioner that should create volumes of this storage class.")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public V1StorageClass provisioner(String provisioner) {
        this.provisioner = provisioner;
        return this;
    }

    @ApiModelProperty(required=true, value="provisioner indicates the type of the provisioner.")
    public String getProvisioner() {
        return this.provisioner;
    }

    public void setProvisioner(String provisioner) {
        this.provisioner = provisioner;
    }

    public V1StorageClass reclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="reclaimPolicy controls the reclaimPolicy for dynamically provisioned PersistentVolumes of this storage class. Defaults to Delete.")
    public String getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    public void setReclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
    }

    public V1StorageClass volumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.")
    public String getVolumeBindingMode() {
        return this.volumeBindingMode;
    }

    public void setVolumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StorageClass v1StorageClass = (V1StorageClass)o;
        return Objects.equals(this.allowVolumeExpansion, v1StorageClass.allowVolumeExpansion) && Objects.equals(this.allowedTopologies, v1StorageClass.allowedTopologies) && Objects.equals(this.apiVersion, v1StorageClass.apiVersion) && Objects.equals(this.kind, v1StorageClass.kind) && Objects.equals(this.metadata, v1StorageClass.metadata) && Objects.equals(this.mountOptions, v1StorageClass.mountOptions) && Objects.equals(this.parameters, v1StorageClass.parameters) && Objects.equals(this.provisioner, v1StorageClass.provisioner) && Objects.equals(this.reclaimPolicy, v1StorageClass.reclaimPolicy) && Objects.equals(this.volumeBindingMode, v1StorageClass.volumeBindingMode);
    }

    public int hashCode() {
        return Objects.hash(this.allowVolumeExpansion, this.allowedTopologies, this.apiVersion, this.kind, this.metadata, this.mountOptions, this.parameters, this.provisioner, this.reclaimPolicy, this.volumeBindingMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StorageClass {\n");
        sb.append("    allowVolumeExpansion: ").append(this.toIndentedString(this.allowVolumeExpansion)).append("\n");
        sb.append("    allowedTopologies: ").append(this.toIndentedString(this.allowedTopologies)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mountOptions: ").append(this.toIndentedString(this.mountOptions)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    provisioner: ").append(this.toIndentedString(this.provisioner)).append("\n");
        sb.append("    reclaimPolicy: ").append(this.toIndentedString(this.reclaimPolicy)).append("\n");
        sb.append("    volumeBindingMode: ").append(this.toIndentedString(this.volumeBindingMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

