/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.report.IngestionStatsAndErrors;
import org.apache.druid.indexer.report.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexer.report.TaskContextReport;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalAppendAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalReplaceAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TimeChunkLockTryAcquireAction;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.FilteringCloseableInputRowIterator;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.TaskLockHelper;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.TaskResourceCleaner;
import org.apache.druid.indexing.common.task.Tasks;
import org.apache.druid.indexing.common.task.batch.MaxAllowedLocksExceededException;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.input.InputRowSchemas;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.granularity.IntervalsByGranularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.handoff.SegmentHandoffNotifier;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.IngestionSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public abstract class AbstractBatchIndexTask
extends AbstractTask {
    private static final Logger log = new Logger(AbstractBatchIndexTask.class);
    private boolean segmentAvailabilityConfirmationCompleted = false;
    private long segmentAvailabilityWaitTimeMs = 0L;
    @GuardedBy(value="this")
    private final TaskResourceCleaner resourceCloserOnAbnormalExit = new TaskResourceCleaner();
    @GuardedBy(value="this")
    private boolean stopped = false;
    private TaskLockHelper taskLockHelper;
    private final int maxAllowedLockCount;
    private final Map<Interval, String> intervalToLockVersion = new HashMap<Interval, String>();

    protected AbstractBatchIndexTask(String id, String dataSource, Map<String, Object> context, AbstractTask.IngestionMode ingestionMode) {
        super(id, dataSource, context, ingestionMode);
        this.maxAllowedLockCount = -1;
    }

    protected AbstractBatchIndexTask(String id, @Nullable String groupId, @Nullable TaskResource taskResource, String dataSource, @Nullable Map<String, Object> context, int maxAllowedLockCount, AbstractTask.IngestionMode ingestionMode) {
        super(id, groupId, taskResource, dataSource, context, ingestionMode);
        this.maxAllowedLockCount = maxAllowedLockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setup(TaskToolbox toolbox) throws Exception {
        if (this.taskLockHelper == null && !this.isReady(toolbox.getTaskActionClient())) {
            throw new ISE("Cannot start; not ready!", new Object[0]);
        }
        AbstractBatchIndexTask abstractBatchIndexTask = this;
        synchronized (abstractBatchIndexTask) {
            if (this.stopped) {
                return "Attempting to run a task that has been stopped. See overlord & task logs for more details.";
            }
            Thread currentThread = Thread.currentThread();
            this.resourceCloserOnAbnormalExit.register(config -> currentThread.interrupt());
        }
        return super.setup(toolbox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGracefully(TaskConfig taskConfig) {
        AbstractBatchIndexTask abstractBatchIndexTask = this;
        synchronized (abstractBatchIndexTask) {
            this.stopped = true;
            this.resourceCloserOnAbnormalExit.clean(taskConfig);
        }
    }

    public static FilteringCloseableInputRowIterator inputSourceReader(File tmpDir, DataSchema dataSchema, InputSource inputSource, @Nullable InputFormat inputFormat, Predicate<InputRow> rowFilter, RowIngestionMeters ingestionMeters, ParseExceptionHandler parseExceptionHandler) throws IOException {
        InputSourceReader inputSourceReader = dataSchema.getTransformSpec().decorate(inputSource.reader(InputRowSchemas.fromDataSchema(dataSchema), inputFormat, tmpDir));
        return new FilteringCloseableInputRowIterator((CloseableIterator<InputRow>)inputSourceReader.read((InputStats)ingestionMeters), rowFilter, ingestionMeters, parseExceptionHandler);
    }

    protected static Predicate<InputRow> allowNonNullRowsStrictlyWithinInputIntervalsOf(GranularitySpec granularitySpec) {
        return inputRow -> inputRow != null && granularitySpec.bucketInterval(inputRow.getTimestamp()).isPresent();
    }

    protected static Predicate<InputRow> allowNonNullRowsWithinInputIntervalsOf(GranularitySpec granularitySpec) {
        return inputRow -> inputRow != null && (granularitySpec.inputIntervals().isEmpty() || granularitySpec.bucketInterval(inputRow.getTimestamp()).isPresent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerResourceCloserOnAbnormalExit(Consumer<TaskConfig> cleaner) {
        AbstractBatchIndexTask abstractBatchIndexTask = this;
        synchronized (abstractBatchIndexTask) {
            this.resourceCloserOnAbnormalExit.register(cleaner);
        }
    }

    public abstract boolean requireLockExistingSegments();

    public abstract List<DataSegment> findSegmentsToLock(TaskActionClient var1, List<Interval> var2) throws IOException;

    public abstract boolean isPerfectRollup();

    @Nullable
    public abstract Granularity getSegmentGranularity();

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 50);
    }

    public TaskLockHelper getTaskLockHelper() {
        return (TaskLockHelper)Preconditions.checkNotNull((Object)this.taskLockHelper, (Object)"taskLockHelper is not initialized yet");
    }

    public boolean determineLockGranularityAndTryLock(TaskActionClient client, List<Interval> intervals) throws IOException {
        boolean forceTimeChunkLock = this.getContextValue("forceTimeChunkLock", true);
        AbstractTask.IngestionMode ingestionMode = this.getIngestionMode();
        if (forceTimeChunkLock || ingestionMode == AbstractTask.IngestionMode.REPLACE) {
            log.info("Using time chunk lock since forceTimeChunkLock is [%s] and mode is [%s].", new Object[]{forceTimeChunkLock, ingestionMode});
            this.taskLockHelper = this.createLockHelper(LockGranularity.TIME_CHUNK);
            if (!intervals.isEmpty()) {
                return this.tryTimeChunkLock(client, intervals);
            }
            return true;
        }
        if (!intervals.isEmpty()) {
            LockGranularityDetermineResult result = this.determineSegmentGranularity(client, intervals);
            this.taskLockHelper = this.createLockHelper(result.lockGranularity);
            return this.tryLockWithDetermineResult(client, result);
        }
        return true;
    }

    boolean determineLockGranularityAndTryLockWithSegments(TaskActionClient client, List<DataSegment> segments, BiConsumer<LockGranularity, List<DataSegment>> segmentCheckFunction) throws IOException {
        boolean forceTimeChunkLock = this.getContextValue("forceTimeChunkLock", true);
        if (forceTimeChunkLock) {
            log.info("[%s] is set to true in task context. Use timeChunk lock", new Object[]{"forceTimeChunkLock"});
            this.taskLockHelper = this.createLockHelper(LockGranularity.TIME_CHUNK);
            segmentCheckFunction.accept(LockGranularity.TIME_CHUNK, segments);
            return this.tryTimeChunkLock(client, new ArrayList<Interval>(segments.stream().map(DataSegment::getInterval).collect(Collectors.toSet())));
        }
        LockGranularityDetermineResult result = this.determineSegmentGranularity(segments);
        this.taskLockHelper = this.createLockHelper(result.lockGranularity);
        segmentCheckFunction.accept(result.lockGranularity, segments);
        return this.tryLockWithDetermineResult(client, result);
    }

    private LockGranularityDetermineResult determineSegmentGranularity(TaskActionClient client, List<Interval> intervals) throws IOException {
        if (this.requireLockExistingSegments()) {
            if (this.isPerfectRollup()) {
                log.info("Using timeChunk lock for perfect rollup", new Object[0]);
                return new LockGranularityDetermineResult(LockGranularity.TIME_CHUNK, intervals, null);
            }
            if (!intervals.isEmpty()) {
                return this.determineSegmentGranularity(this.findSegmentsToLock(client, intervals));
            }
            log.info("Using segment lock for empty intervals", new Object[0]);
            return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, Collections.emptyList());
        }
        log.info("Using segment lock since we don't have to lock existing segments", new Object[0]);
        return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, Collections.emptyList());
    }

    private boolean tryLockWithDetermineResult(TaskActionClient client, LockGranularityDetermineResult result) throws IOException {
        if (result.lockGranularity == LockGranularity.TIME_CHUNK) {
            return this.tryTimeChunkLock(client, (List)Preconditions.checkNotNull(result.intervals, (Object)"intervals"));
        }
        return this.taskLockHelper.verifyAndLockExistingSegments(client, (List)Preconditions.checkNotNull(result.segments, (Object)"segments"));
    }

    protected TaskAction<SegmentPublishResult> buildPublishAction(Set<DataSegment> segmentsToBeOverwritten, Set<DataSegment> segmentsToPublish, SegmentSchemaMapping segmentSchemaMapping, TaskLockType lockType) {
        switch (lockType) {
            case REPLACE: {
                return SegmentTransactionalReplaceAction.create(segmentsToPublish, segmentSchemaMapping);
            }
            case APPEND: {
                return SegmentTransactionalAppendAction.forSegments(segmentsToPublish, segmentSchemaMapping);
            }
        }
        return SegmentTransactionalInsertAction.overwriteAction(segmentsToBeOverwritten, segmentsToPublish, segmentSchemaMapping);
    }

    protected TransactionalSegmentPublisher buildSegmentPublisher(final TaskToolbox toolbox) {
        return new TransactionalSegmentPublisher(){

            public SegmentPublishResult publishAnnotatedSegments(@Nullable Set<DataSegment> segmentsToBeOverwritten, Set<DataSegment> segmentsToPublish, @Nullable Object commitMetadata, @Nullable SegmentSchemaMapping schemaMapping) throws IOException {
                return toolbox.getTaskActionClient().submit(AbstractBatchIndexTask.this.buildPublishAction(segmentsToBeOverwritten, segmentsToPublish, schemaMapping, AbstractBatchIndexTask.this.getTaskLockHelper().getLockTypeToUse()));
            }
        };
    }

    protected boolean tryTimeChunkLock(TaskActionClient client, List<Interval> intervals) throws IOException {
        Iterator intervalIterator;
        Granularity segmentGranularity = this.getSegmentGranularity();
        if (segmentGranularity == null) {
            intervalIterator = JodaUtils.condenseIntervals(intervals).iterator();
        } else {
            IntervalsByGranularity intervalsByGranularity = new IntervalsByGranularity(intervals, segmentGranularity);
            intervalIterator = JodaUtils.condensedIntervalsIterator((Iterator)intervalsByGranularity.granularityIntervalsIterator());
        }
        Interval prev = null;
        int locksAcquired = 0;
        while (intervalIterator.hasNext()) {
            Interval cur = (Interval)intervalIterator.next();
            if (prev != null && cur.equals(prev)) continue;
            if (this.maxAllowedLockCount >= 0 && locksAcquired >= this.maxAllowedLockCount) {
                throw new MaxAllowedLocksExceededException(this.maxAllowedLockCount);
            }
            prev = cur;
            TaskLockType taskLockType = this.determineLockType(LockGranularity.TIME_CHUNK);
            TaskLock lock = client.submit(new TimeChunkLockTryAcquireAction(taskLockType, cur));
            if (lock == null) {
                return false;
            }
            lock.assertNotRevoked();
            ++locksAcquired;
            this.intervalToLockVersion.put(cur, lock.getVersion());
        }
        return true;
    }

    private TaskLockHelper createLockHelper(LockGranularity lockGranularity) {
        return new TaskLockHelper(lockGranularity == LockGranularity.SEGMENT, this.determineLockType(lockGranularity));
    }

    public TaskLockType determineLockType(LockGranularity lockGranularity) {
        if (lockGranularity == LockGranularity.SEGMENT) {
            return TaskLockType.EXCLUSIVE;
        }
        boolean useConcurrentLocks = QueryContexts.getAsBoolean((String)"useConcurrentLocks", this.getContextValue("useConcurrentLocks"), (boolean)false);
        AbstractTask.IngestionMode ingestionMode = this.getIngestionMode();
        if (useConcurrentLocks) {
            return ingestionMode == AbstractTask.IngestionMode.APPEND ? TaskLockType.APPEND : TaskLockType.REPLACE;
        }
        TaskLockType contextTaskLockType = (TaskLockType)QueryContexts.getAsEnum((String)"taskLockType", this.getContextValue("taskLockType"), TaskLockType.class);
        TaskLockType lockType = contextTaskLockType == null ? (this.getContextValue("useSharedLock", false) != false ? TaskLockType.SHARED : TaskLockType.EXCLUSIVE) : contextTaskLockType;
        if ((lockType == TaskLockType.SHARED || lockType == TaskLockType.APPEND) && ingestionMode != AbstractTask.IngestionMode.APPEND) {
            return Tasks.DEFAULT_TASK_LOCK_TYPE;
        }
        return lockType;
    }

    private LockGranularityDetermineResult determineSegmentGranularity(List<DataSegment> segments) {
        if (segments.isEmpty()) {
            log.info("Using segment lock for empty segments", new Object[0]);
            return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, Collections.emptyList());
        }
        if (this.requireLockExistingSegments()) {
            Granularity granularityFromSegments = AbstractBatchIndexTask.findGranularityFromSegments(segments);
            Granularity segmentGranularityFromSpec = this.getSegmentGranularity();
            List<Interval> intervals = segments.stream().map(DataSegment::getInterval).collect(Collectors.toList());
            if (granularityFromSegments == null || segmentGranularityFromSpec != null && (!granularityFromSegments.equals(segmentGranularityFromSpec) || segments.stream().anyMatch(segment -> !segmentGranularityFromSpec.isAligned(segment.getInterval())))) {
                log.info("Detected segmentGranularity change. Using timeChunk lock", new Object[0]);
                return new LockGranularityDetermineResult(LockGranularity.TIME_CHUNK, intervals, null);
            }
            SegmentTimeline timeline = SegmentTimeline.forSegments(segments);
            Set segmentsToLock = timeline.findNonOvershadowedObjectsInInterval(JodaUtils.umbrellaInterval(intervals), Partitions.ONLY_COMPLETE);
            log.info("No segmentGranularity change detected and it's not perfect rollup. Using segment lock", new Object[0]);
            return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, new ArrayList<DataSegment>(segmentsToLock));
        }
        log.info("Using segment lock since we don't have to lock existing segments", new Object[0]);
        return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, Collections.emptyList());
    }

    public static boolean isGuaranteedRollup(AbstractTask.IngestionMode ingestionMode, IndexTask.IndexTuningConfig tuningConfig) {
        Preconditions.checkArgument((ingestionMode != AbstractTask.IngestionMode.APPEND || !tuningConfig.isForceGuaranteedRollup() ? 1 : 0) != 0, (Object)"Perfect rollup cannot be guaranteed when appending to existing dataSources");
        return tuningConfig.isForceGuaranteedRollup();
    }

    public static Function<Set<DataSegment>, Set<DataSegment>> addCompactionStateToSegments(boolean storeCompactionState, TaskToolbox toolbox, IngestionSpec ingestionSpec) {
        if (storeCompactionState) {
            DimensionsSpec dimensionsSpec;
            TuningConfig tuningConfig = ingestionSpec.getTuningConfig();
            GranularitySpec granularitySpec = ingestionSpec.getDataSchema().getGranularitySpec();
            if (ingestionSpec.getDataSchema().getDimensionsSpec() == null) {
                dimensionsSpec = null;
            } else {
                DimensionsSpec inputDimensionsSpec = ingestionSpec.getDataSchema().getDimensionsSpec();
                dimensionsSpec = DimensionsSpec.builder().setDimensions(inputDimensionsSpec.getDimensions()).setForceSegmentSortByTime(inputDimensionsSpec.isForceSegmentSortByTimeConfigured()).build();
            }
            CompactionTransformSpec transformSpec = CompactionTransformSpec.of((TransformSpec)ingestionSpec.getDataSchema().getTransformSpec());
            List<AggregatorFactory> metricsSpec = ingestionSpec.getDataSchema().getAggregators() == null ? null : Arrays.asList(ingestionSpec.getDataSchema().getAggregators());
            return CompactionState.addCompactionStateToSegments((PartitionsSpec)tuningConfig.getPartitionsSpec(), (DimensionsSpec)dimensionsSpec, metricsSpec, (CompactionTransformSpec)transformSpec, (IndexSpec)tuningConfig.getIndexSpec(), (GranularitySpec)granularitySpec, (List)ingestionSpec.getDataSchema().getProjections());
        }
        return Function.identity();
    }

    @Nullable
    static Granularity findGranularityFromSegments(List<DataSegment> segments) {
        if (segments.isEmpty()) {
            return null;
        }
        Period firstSegmentPeriod = segments.get(0).getInterval().toPeriod();
        boolean allHasSameGranularity = segments.stream().allMatch(segment -> firstSegmentPeriod.equals((Object)segment.getInterval().toPeriod()));
        if (allHasSameGranularity) {
            return GranularityType.fromPeriod((Period)firstSegmentPeriod).getDefaultGranularity();
        }
        return null;
    }

    protected static List<DataSegment> findInputSegments(String dataSource, TaskActionClient actionClient, List<Interval> intervalsToRead) throws IOException {
        return ImmutableList.copyOf(actionClient.submit(new RetrieveUsedSegmentsAction(dataSource, intervalsToRead)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForSegmentAvailability(TaskToolbox toolbox, List<DataSegment> segmentsToWaitFor, long waitTimeout) {
        if (segmentsToWaitFor.isEmpty()) {
            log.info("No segments to wait for availability.", new Object[0]);
            return true;
        }
        if (waitTimeout < 0L) {
            log.warn("Not waiting for segment availability as waitTimeout[%s] is less than zero.", new Object[]{waitTimeout});
            return false;
        }
        log.info("Waiting for [%d] segments to be loaded by the cluster...", new Object[]{segmentsToWaitFor.size()});
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            boolean bl;
            block14: {
                SegmentHandoffNotifier notifier = toolbox.getSegmentHandoffNotifierFactory().createSegmentHandoffNotifier(segmentsToWaitFor.get(0).getDataSource(), this.getId());
                try {
                    ListeningExecutorService exec = Execs.directExecutor();
                    CountDownLatch doneSignal = new CountDownLatch(segmentsToWaitFor.size());
                    notifier.start();
                    for (DataSegment s : segmentsToWaitFor) {
                        notifier.registerSegmentHandoffCallback(new SegmentDescriptor(s.getInterval(), s.getVersion(), s.getShardSpec().getPartitionNum()), (Executor)exec, () -> {
                            doneSignal.countDown();
                            log.debug("Segment[%s] is now available, [%d] segments remaining.", new Object[]{s.getId(), doneSignal.getCount()});
                        });
                    }
                    bl = this.segmentAvailabilityConfirmationCompleted = doneSignal.await(waitTimeout, TimeUnit.MILLISECONDS);
                    if (notifier == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (notifier != null) {
                            try {
                                notifier.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        log.warn("Interrupted while waiting for segment availablity; Unable to confirm availability!", new Object[0]);
                        Thread.currentThread().interrupt();
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                notifier.close();
            }
            return bl;
        }
        finally {
            this.segmentAvailabilityWaitTimeMs = stopwatch.millisElapsed();
            toolbox.getEmitter().emit((ServiceEventBuilder)new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)this.getDataSource()).setDimension("taskType", (Object)this.getType()).setDimension("taskId", (Object)this.getId()).setDimension("groupId", (Object)this.getGroupId()).setDimensionIfNotNull("tags", this.getContextValue("tags")).setDimension("segmentAvailabilityConfirmed", (Object)this.segmentAvailabilityConfirmationCompleted).setMetric("task/segmentAvailability/wait/time", (Number)this.segmentAvailabilityWaitTimeMs));
        }
    }

    @Nullable
    public static String findVersion(Map<Interval, String> versions, Interval interval) {
        return versions.entrySet().stream().filter(entry -> ((Interval)entry.getKey()).contains((ReadableInterval)interval)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public static NonnullPair<Interval, String> findIntervalAndVersion(TaskToolbox toolbox, IngestionSpec<?, ?> ingestionSpec, DateTime timestamp, TaskLockType taskLockType) throws IOException {
        String version;
        Interval interval;
        GranularitySpec granularitySpec = ingestionSpec.getDataSchema().getGranularitySpec();
        TreeSet materializedBucketIntervals = granularitySpec.materializedBucketIntervals();
        List<TaskLock> locks = toolbox.getTaskActionClient().submit(new LockListAction());
        TaskLock revokedLock = locks.stream().filter(TaskLock::isRevoked).findAny().orElse(null);
        if (revokedLock != null) {
            throw new ISE("Lock revoked: [%s]", new Object[]{revokedLock});
        }
        Map<Interval, String> versions = locks.stream().collect(Collectors.toMap(TaskLock::getInterval, TaskLock::getVersion));
        if (!materializedBucketIntervals.isEmpty()) {
            com.google.common.base.Optional maybeInterval = granularitySpec.bucketInterval(timestamp);
            if (!maybeInterval.isPresent()) {
                throw new IAE("Could not find interval for timestamp [%s]", new Object[]{timestamp});
            }
            interval = (Interval)maybeInterval.get();
            if (!materializedBucketIntervals.contains(interval)) {
                throw new ISE("Unspecified interval[%s] in granularitySpec[%s]", new Object[]{interval, granularitySpec});
            }
            version = AbstractBatchIndexTask.findVersion(versions, interval);
            if (version == null) {
                throw new ISE("Cannot find a version for interval[%s]", new Object[]{interval});
            }
        } else {
            interval = granularitySpec.getSegmentGranularity().bucket(timestamp);
            String existingLockVersion = AbstractBatchIndexTask.findVersion(versions, interval);
            if (existingLockVersion == null) {
                int maxAllowedLockCount;
                if (ingestionSpec.getTuningConfig() instanceof ParallelIndexTuningConfig && (maxAllowedLockCount = ((ParallelIndexTuningConfig)ingestionSpec.getTuningConfig()).getMaxAllowedLockCount()) >= 0 && locks.size() >= maxAllowedLockCount) {
                    throw new MaxAllowedLocksExceededException(maxAllowedLockCount);
                }
                TaskLock lock = (TaskLock)Preconditions.checkNotNull((Object)toolbox.getTaskActionClient().submit(new TimeChunkLockTryAcquireAction(taskLockType, interval)), (String)"Cannot acquire a lock for interval[%s]", (Object)interval);
                lock.assertNotRevoked();
                version = lock.getVersion();
            } else {
                version = existingLockVersion;
            }
        }
        return new NonnullPair((Object)interval, (Object)version);
    }

    @Nullable
    private Pair<Interval, String> lookupVersion(DateTime timestamp) {
        Optional<Map.Entry> intervalAndVersion = this.intervalToLockVersion.entrySet().stream().filter(e -> ((Interval)e.getKey()).contains((ReadableInstant)timestamp)).findFirst();
        return intervalAndVersion.map(entry -> new Pair((Object)((Interval)entry.getKey()), (Object)((String)entry.getValue()))).orElse(null);
    }

    protected SegmentIdWithShardSpec allocateNewSegmentForTombstone(IngestionSpec ingestionSchema, DateTime timestamp) {
        Pair<Interval, String> intervalAndVersion = this.lookupVersion(timestamp);
        return new SegmentIdWithShardSpec(ingestionSchema.getDataSchema().getDataSource(), (Interval)intervalAndVersion.lhs, (String)intervalAndVersion.rhs, (ShardSpec)new TombstoneShardSpec());
    }

    @Nullable
    protected Map<String, Object> getTaskCompletionRowStats() {
        return null;
    }

    @Nullable
    protected Map<String, Object> getTaskCompletionUnparseableEvents() {
        return null;
    }

    protected TaskReport.ReportMap buildLiveIngestionStatsReport(IngestionState ingestionState, Map<String, Object> unparseableEvents, Map<String, Object> rowStats) {
        return TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{new IngestionStatsAndErrorsTaskReport(this.getId(), new IngestionStatsAndErrors(ingestionState, unparseableEvents, rowStats, null, false, 0L, null, null, null))});
    }

    protected TaskReport.ReportMap buildIngestionStatsAndContextReport(IngestionState ingestionState, String errorMessage, Long segmentsRead, Long segmentsPublished) {
        return TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{this.buildIngestionStatsTaskReport(ingestionState, errorMessage, segmentsRead, segmentsPublished), new TaskContextReport(this.getId(), this.getContext())});
    }

    protected TaskReport.ReportMap buildIngestionStatsReport(IngestionState ingestionState, String errorMessage, Long segmentsRead, Long segmentsPublished) {
        return TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{this.buildIngestionStatsTaskReport(ingestionState, errorMessage, segmentsRead, segmentsPublished)});
    }

    private IngestionStatsAndErrorsTaskReport buildIngestionStatsTaskReport(IngestionState ingestionState, String errorMessage, Long segmentsRead, Long segmentsPublished) {
        return new IngestionStatsAndErrorsTaskReport(this.getId(), new IngestionStatsAndErrors(ingestionState, this.getTaskCompletionUnparseableEvents(), this.getTaskCompletionRowStats(), errorMessage, this.segmentAvailabilityConfirmationCompleted, this.segmentAvailabilityWaitTimeMs, Collections.emptyMap(), segmentsRead, segmentsPublished));
    }

    protected static boolean addBuildSegmentStatsToReport(boolean isFullReport, IngestionState ingestionState) {
        return isFullReport || ingestionState == IngestionState.BUILD_SEGMENTS || ingestionState == IngestionState.COMPLETED;
    }

    private static class LockGranularityDetermineResult {
        private final LockGranularity lockGranularity;
        @Nullable
        private final List<Interval> intervals;
        @Nullable
        private final List<DataSegment> segments;

        private LockGranularityDetermineResult(LockGranularity lockGranularity, @Nullable List<Interval> intervals, @Nullable List<DataSegment> segments) {
            this.lockGranularity = lockGranularity;
            this.intervals = intervals;
            this.segments = segments;
        }
    }
}

