/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.HumanReadableBytes;

public class SamplerConfig {
    private static final int DEFAULT_NUM_ROWS = 200;
    private static final int MAX_NUM_ROWS = 5000;
    private static final int DEFAULT_TIMEOUT_MS = 10000;
    private final int numRows;
    private final int timeoutMs;
    private final long maxBytesInMemory;
    private final long maxClientResponseBytes;

    @JsonCreator
    public SamplerConfig(@JsonProperty(value="numRows") @Nullable Integer numRows, @JsonProperty(value="timeoutMs") @Nullable Integer timeoutMs, @JsonProperty(value="maxBytesInMemory") @Nullable HumanReadableBytes maxBytesInMemory, @JsonProperty(value="maxClientResponseBytes") @Nullable HumanReadableBytes maxClientResponseBytes) {
        this.numRows = numRows != null ? numRows : 200;
        this.timeoutMs = timeoutMs != null ? timeoutMs : 10000;
        this.maxBytesInMemory = maxBytesInMemory != null ? maxBytesInMemory.getBytes() : Long.MAX_VALUE;
        this.maxClientResponseBytes = maxClientResponseBytes != null ? maxClientResponseBytes.getBytes() : 0L;
        Preconditions.checkArgument((this.numRows <= 5000 ? 1 : 0) != 0, (String)"numRows must be <= %s", (int)5000);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    public long getMaxClientResponseBytes() {
        return this.maxClientResponseBytes;
    }

    public static SamplerConfig empty() {
        return new SamplerConfig(null, null, null, null);
    }
}

