/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.JavaScriptUtil;
import org.apache.druid.indexing.overlord.setup.WorkerSelectStrategy;
import org.apache.druid.js.JavaScriptConfig;

public class JavaScriptWorkerSelectStrategy
implements WorkerSelectStrategy {
    private final String function;
    private SelectorFunction fnSelector;

    @JsonCreator
    public JavaScriptWorkerSelectStrategy(@JsonProperty(value="function") String fn, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull((Object)fn, (Object)"function must not be null");
        Preconditions.checkState((boolean)config.isEnabled(), (Object)"JavaScript is disabled");
        this.function = fn;
    }

    @Override
    public ImmutableWorkerInfo findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        this.fnSelector = this.fnSelector == null ? JavaScriptUtil.compileSelectorFunction(SelectorFunction.class, this.function) : this.fnSelector;
        String worker = this.fnSelector.apply(config, zkWorkers, task);
        return worker == null ? null : (ImmutableWorkerInfo)zkWorkers.get((Object)worker);
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptWorkerSelectStrategy that = (JavaScriptWorkerSelectStrategy)o;
        return !(this.function != null ? !this.function.equals(that.function) : that.function != null);
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public String toString() {
        return "JavaScriptWorkerSelectStrategy{function='" + this.function + "'}";
    }

    public static interface SelectorFunction {
        public String apply(WorkerTaskRunnerConfig var1, ImmutableMap<String, ImmutableWorkerInfo> var2, Task var3);
    }
}

