/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FSSpideringIterator
implements Iterator<FileStatus> {
    private final FileSystem fs;
    private final FileStatus[] statii;
    private FileStatus nextStatus = null;
    private FSSpideringIterator statuses = null;
    int index = 0;

    public static FSSpideringIterator spiderPathPropagateExceptions(FileSystem fs, Path path) {
        try {
            FileStatus[] statii = fs.listStatus(path);
            return new FSSpideringIterator(fs, statii == null ? new FileStatus[]{} : statii);
        }
        catch (FileNotFoundException e) {
            return new FSSpideringIterator(fs, new FileStatus[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Iterable<FileStatus> spiderIterable(final FileSystem fs, final Path path) {
        return new Iterable<FileStatus>(){

            @Override
            public Iterator<FileStatus> iterator() {
                return FSSpideringIterator.spiderPathPropagateExceptions(fs, path);
            }
        };
    }

    public FSSpideringIterator(FileSystem fs, FileStatus[] statii) {
        this.fs = fs;
        this.statii = statii;
    }

    @Override
    public boolean hasNext() {
        this.fetchNextIfNeeded();
        return this.nextStatus != null;
    }

    @Override
    public FileStatus next() {
        this.fetchNextIfNeeded();
        if (this.nextStatus == null) {
            throw new NoSuchElementException();
        }
        FileStatus result = this.nextStatus;
        this.nextStatus = null;
        return result;
    }

    private void fetchNextIfNeeded() {
        while (this.nextStatus == null && this.index < this.statii.length) {
            if (this.statii[this.index].isDirectory()) {
                if (this.statuses == null) {
                    this.statuses = FSSpideringIterator.spiderPathPropagateExceptions(this.fs, this.statii[this.index].getPath());
                    continue;
                }
                if (this.statuses.hasNext()) {
                    this.nextStatus = this.statuses.next();
                    continue;
                }
                if (this.index == this.statii.length - 1) {
                    return;
                }
                this.statuses = null;
                ++this.index;
                continue;
            }
            ++this.index;
            this.nextStatus = this.statii[this.index - 1];
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

