/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.processor.BlockingQueueOutputChannelFactory;
import org.apache.druid.frame.processor.ComposingOutputChannelFactory;
import org.apache.druid.frame.processor.FileOutputChannelFactory;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.exec.ExecutionContext;
import org.apache.druid.msq.exec.ExecutionContextImpl;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.exec.ListeningOutputChannelFactory;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.exec.RunWorkOrderListener;
import org.apache.druid.msq.exec.StageProcessor;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.indexing.InputChannelsImpl;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.InputSlices;
import org.apache.druid.msq.input.MapInputSliceReader;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.NilInputSliceReader;
import org.apache.druid.msq.input.external.ExternalInputSlice;
import org.apache.druid.msq.input.external.ExternalInputSliceReader;
import org.apache.druid.msq.input.inline.InlineInputSlice;
import org.apache.druid.msq.input.inline.InlineInputSliceReader;
import org.apache.druid.msq.input.lookup.LookupInputSlice;
import org.apache.druid.msq.input.lookup.LookupInputSliceReader;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.input.stage.StageInputSliceReader;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.input.table.SegmentsInputSliceReader;
import org.apache.druid.msq.kernel.ShuffleKind;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.shuffle.output.DurableStorageOutputChannelFactory;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class RunWorkOrder {
    private final WorkOrder workOrder;
    private final InputChannelFactory inputChannelFactory;
    private final CounterTracker counterTracker;
    private final FrameProcessorExecutor exec;
    private final String cancellationId;
    private final WorkerContext workerContext;
    private final FrameContext frameContext;
    private final RunWorkOrderListener listener;
    private final ByteTracker intermediateByteTracker;
    @GuardedBy(value="stageOutputChannels")
    private final List<OutputChannel> stageOutputChannels = new ArrayList<OutputChannel>();
    private final SettableFuture<ClusterByPartitions> stagePartitionBoundariesFuture = SettableFuture.create();
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private final AtomicReference<Either<Throwable, Object>> resultForListener = new AtomicReference();
    private @MonotonicNonNull ListenableFuture<?> stageResultFuture;

    public RunWorkOrder(WorkOrder workOrder, InputChannelFactory inputChannelFactory, CounterTracker counterTracker, FrameProcessorExecutor exec, String cancellationId, WorkerContext workerContext, FrameContext frameContext, RunWorkOrderListener listener) {
        this.workOrder = workOrder;
        this.inputChannelFactory = inputChannelFactory;
        this.counterTracker = counterTracker;
        this.exec = exec;
        this.cancellationId = cancellationId;
        this.workerContext = workerContext;
        this.frameContext = frameContext;
        this.listener = listener;
        this.intermediateByteTracker = new ByteTracker(frameContext.storageParameters().isIntermediateStorageLimitConfigured() ? frameContext.storageParameters().getIntermediateSuperSorterStorageMaxLocalBytes() : Long.MAX_VALUE);
    }

    public void startAsync() {
        if (!this.state.compareAndSet(State.INIT, State.STARTED)) {
            throw new ISE("Cannot start from state[%s]", new Object[]{this.state});
        }
        try {
            this.exec.registerCancellationId(this.cancellationId);
            this.initGlobalSortPartitionBoundariesIfNeeded();
            this.startStageProcessor();
            this.setUpCompletionCallbacks();
        }
        catch (Throwable t) {
            this.stop(t);
        }
    }

    public void stop(@Nullable Throwable t) {
        if (this.state.compareAndSet(State.INIT, State.STOPPING) || this.state.compareAndSet(State.STARTED, State.STOPPING) || this.state.compareAndSet(State.FAILED, State.STOPPING)) {
            try {
                this.exec.cancel(this.cancellationId);
            }
            catch (Throwable e2) {
                if (t == null) {
                    t = e2;
                }
                t.addSuppressed(e2);
            }
            try {
                this.frameContext.close();
            }
            catch (Throwable e2) {
                if (t == null) {
                    t = e2;
                }
                t.addSuppressed(e2);
            }
            try {
                this.notifyListener((Either<Throwable, Object>)Either.error((Object)(t != null ? t : new MSQException(CanceledFault.unknown()))));
            }
            catch (Throwable e2) {
                if (t == null) {
                    t = e2;
                }
                t.addSuppressed(e2);
            }
            this.stopLatch.countDown();
        }
        boolean interrupted = false;
        while (this.stopLatch.getCount() > 0L) {
            try {
                this.stopLatch.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (t != null) {
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    public SettableFuture<ClusterByPartitions> getStagePartitionBoundariesFuture() {
        return this.stagePartitionBoundariesFuture;
    }

    private void startStageProcessor() {
        if (this.stageResultFuture != null) {
            throw new ISE("stageResultAndChannelsFuture already set", new Object[0]);
        }
        StageProcessor processor = this.workOrder.getStageDefinition().getProcessor();
        ExecutionContext executionContext = this.makeExecutionContext();
        this.stageResultFuture = processor.execute(executionContext);
    }

    private void initGlobalSortPartitionBoundariesIfNeeded() {
        if (this.workOrder.getStageDefinition().doesShuffle() && this.workOrder.getStageDefinition().getShuffleSpec().kind() == ShuffleKind.GLOBAL_SORT && !this.workOrder.getStageDefinition().mustGatherResultKeyStatistics()) {
            ClusterByPartitions boundaries = (ClusterByPartitions)this.workOrder.getStageDefinition().generatePartitionBoundariesForShuffle(null).valueOrThrow();
            this.stagePartitionBoundariesFuture.set((Object)boundaries);
        }
    }

    private void setUpCompletionCallbacks() {
        Futures.addCallback(this.stageResultFuture, (FutureCallback)new FutureCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(Object resultObject) {
                try {
                    OutputChannels outputChannels;
                    List<OutputChannel> list = RunWorkOrder.this.stageOutputChannels;
                    synchronized (list) {
                        RunWorkOrder.this.stageOutputChannels.sort(Comparator.comparing(OutputChannel::getPartitionNumber));
                        outputChannels = OutputChannels.wrap(RunWorkOrder.this.stageOutputChannels.stream().sorted(Comparator.comparing(OutputChannel::getPartitionNumber)).collect(Collectors.toList()));
                        RunWorkOrder.this.stageOutputChannels.clear();
                    }
                    if (RunWorkOrder.this.workOrder.getOutputChannelMode() != OutputChannelMode.MEMORY) {
                        for (OutputChannel channel : outputChannels.getAllChannels()) {
                            RunWorkOrder.this.listener.onOutputChannelAvailable(channel);
                        }
                    }
                    if (RunWorkOrder.this.workOrder.getOutputChannelMode().isDurable()) {
                        RunWorkOrder.this.writeDurableStorageSuccessFile();
                    }
                    RunWorkOrder.this.notifyListener((Either<Throwable, Object>)Either.value((Object)resultObject));
                }
                catch (Throwable t) {
                    this.onFailure(t);
                }
            }

            public void onFailure(Throwable t) {
                if (RunWorkOrder.this.state.compareAndSet(State.STARTED, State.FAILED)) {
                    RunWorkOrder.this.notifyListener((Either<Throwable, Object>)Either.error((Object)t));
                }
            }
        }, (Executor)Execs.directExecutor());
    }

    private void notifyListener(Either<Throwable, Object> result) {
        if (this.resultForListener.compareAndSet(null, result)) {
            if (result.isError()) {
                this.listener.onFailure((Throwable)result.error());
            } else {
                this.listener.onSuccess(result.valueOrThrow());
            }
        }
    }

    private void writeDurableStorageSuccessFile() {
        DurableStorageOutputChannelFactory durableStorageOutputChannelFactory = this.makeDurableStorageOutputChannelFactory(this.frameContext.tempDir("durable"), this.frameContext.memoryParameters().getFrameSize(), this.workOrder.getOutputChannelMode() == OutputChannelMode.DURABLE_STORAGE_QUERY_RESULTS);
        try {
            durableStorageOutputChannelFactory.createSuccessFile(this.workerContext.workerId());
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "Unable to create success file at location[%s]", new Object[]{durableStorageOutputChannelFactory.getSuccessFilePath()});
        }
    }

    private ExecutionContext makeExecutionContext() {
        return new ExecutionContextImpl(this.workOrder, this.exec, this.makeInputSliceReader(), this::makeIntermediateOutputChannelFactory, this.makeStageOutputChannelFactory(), this.stagePartitionBoundariesFuture, this.frameContext, this.counterTracker, this.workerContext.threadCount(), this.cancellationId, this.listener);
    }

    private InputSliceReader makeInputSliceReader() {
        String queryId = this.workOrder.getQueryDefinition().getQueryId();
        boolean reindex = MultiStageQueryContext.isReindex(this.workOrder.getWorkerContext());
        InputChannelsImpl inputChannels = new InputChannelsImpl(this.workOrder.getQueryDefinition(), InputSlices.allReadablePartitions(this.workOrder.getInputs()), this.inputChannelFactory, this.frameContext.frameWriterSpec(), () -> ArenaMemoryAllocator.createOnHeap((int)this.frameContext.memoryParameters().getFrameSize()), this.exec, this.cancellationId, this.counterTracker);
        return new MapInputSliceReader((Map<Class<? extends InputSlice>, InputSliceReader>)ImmutableMap.builder().put(NilInputSlice.class, (Object)NilInputSliceReader.INSTANCE).put(StageInputSlice.class, (Object)new StageInputSliceReader(queryId, inputChannels)).put(ExternalInputSlice.class, (Object)new ExternalInputSliceReader(this.frameContext.tempDir("external"))).put(InlineInputSlice.class, (Object)new InlineInputSliceReader(this.frameContext.segmentWrangler())).put(LookupInputSlice.class, (Object)new LookupInputSliceReader(this.frameContext.segmentWrangler())).put(SegmentsInputSlice.class, (Object)new SegmentsInputSliceReader(this.frameContext, reindex)).build());
    }

    private OutputChannelFactory makeStageOutputChannelFactory() {
        Object outputChannelFactory;
        int frameSize = this.frameContext.memoryParameters().getFrameSize();
        OutputChannelMode outputChannelMode = this.workOrder.getOutputChannelMode();
        switch (outputChannelMode) {
            case MEMORY: {
                outputChannelFactory = new ListeningOutputChannelFactory((OutputChannelFactory)new BlockingQueueOutputChannelFactory(frameSize), this.listener::onOutputChannelAvailable);
                break;
            }
            case LOCAL_STORAGE: {
                File fileChannelDirectory = this.frameContext.tempDir(StringUtils.format((String)"output_stage_%06d", (Object[])new Object[]{this.workOrder.getStageNumber()}));
                outputChannelFactory = new FileOutputChannelFactory(fileChannelDirectory, frameSize, null);
                break;
            }
            case DURABLE_STORAGE_INTERMEDIATE: 
            case DURABLE_STORAGE_QUERY_RESULTS: {
                outputChannelFactory = this.makeDurableStorageOutputChannelFactory(this.frameContext.tempDir("durable"), frameSize, outputChannelMode == OutputChannelMode.DURABLE_STORAGE_QUERY_RESULTS);
                break;
            }
            default: {
                throw DruidException.defensive((String)"No handling for outputChannelMode[%s]", (Object[])new Object[]{outputChannelMode});
            }
        }
        return new ListeningOutputChannelFactory((OutputChannelFactory)outputChannelFactory, channel -> {
            List<OutputChannel> list = this.stageOutputChannels;
            synchronized (list) {
                this.stageOutputChannels.add(channel.readOnly());
            }
        });
    }

    private OutputChannelFactory makeIntermediateOutputChannelFactory(String name) {
        File tempDir = this.frameContext.tempDir(name);
        int frameSize = this.frameContext.memoryParameters().getFrameSize();
        File fileChannelDirectory = new File(tempDir, StringUtils.format((String)"intermediate-stage-%06d", (Object[])new Object[]{this.workOrder.getStageNumber()}));
        FileOutputChannelFactory fileOutputChannelFactory = new FileOutputChannelFactory(fileChannelDirectory, frameSize, this.intermediateByteTracker);
        if (this.workOrder.getOutputChannelMode().isDurable() && this.frameContext.storageParameters().isIntermediateStorageLimitConfigured()) {
            boolean isQueryResults = this.workOrder.getOutputChannelMode() == OutputChannelMode.DURABLE_STORAGE_QUERY_RESULTS;
            return new ComposingOutputChannelFactory((List)ImmutableList.of((Object)fileOutputChannelFactory, (Object)this.makeDurableStorageOutputChannelFactory(tempDir, frameSize, isQueryResults)), frameSize);
        }
        return fileOutputChannelFactory;
    }

    private DurableStorageOutputChannelFactory makeDurableStorageOutputChannelFactory(File tmpDir, int frameSize, boolean isQueryResults) {
        return DurableStorageOutputChannelFactory.createStandardImplementation(this.workerContext.queryId(), this.workOrder.getWorkerNumber(), this.workOrder.getStageNumber(), this.workerContext.workerId(), frameSize, MSQTasks.makeStorageConnector(this.workerContext.injector()), tmpDir, isQueryResults);
    }

    static enum State {
        INIT,
        STARTED,
        FAILED,
        STOPPING,
        STOPPED;

    }
}

