/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.util;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DecoratedExecutorService
implements ListeningExecutorService {
    private final ListeningExecutorService exec;
    private final Decorator decorator;

    public DecoratedExecutorService(ListeningExecutorService exec, Decorator decorator) {
        this.exec = exec;
        this.decorator = decorator;
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return this.exec.submit(this.decorator.decorateCallable(task));
    }

    public ListenableFuture<?> submit(Runnable task) {
        return this.exec.submit(this.decorator.decorateRunnable(task));
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.exec.submit(this.decorator.decorateRunnable(task), result);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Callable<T>> decoratedTasks = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            decoratedTasks.add(this.decorator.decorateCallable(task));
        }
        return this.exec.invokeAll(decoratedTasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Callable<T>> decoratedTasks = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            decoratedTasks.add(this.decorator.decorateCallable(task));
        }
        return this.exec.invokeAll(decoratedTasks, timeout, unit);
    }

    public void shutdown() {
        this.exec.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.exec.shutdownNow();
    }

    public boolean isShutdown() {
        return this.exec.isShutdown();
    }

    public boolean isTerminated() {
        return this.exec.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.exec.awaitTermination(timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ArrayList<Callable<T>> decoratedTasks = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            decoratedTasks.add(this.decorator.decorateCallable(task));
        }
        return (T)this.exec.invokeAny(decoratedTasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Callable<T>> decoratedTasks = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            decoratedTasks.add(this.decorator.decorateCallable(task));
        }
        return (T)this.exec.invokeAny(decoratedTasks, timeout, unit);
    }

    public void execute(Runnable command) {
        this.exec.execute(this.decorator.decorateRunnable(command));
    }

    public static interface Decorator {
        public <T> Callable<T> decorateCallable(Callable<T> var1);

        public Runnable decorateRunnable(Runnable var1);
    }
}

