/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.avro.generic.GenericRecord;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.avro.AvroParsers;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;

public class AvroHadoopInputRowParser
implements InputRowParser<GenericRecord> {
    private final ParseSpec parseSpec;
    private final boolean fromPigAvroStorage;
    private final boolean binaryAsString;
    private final boolean extractUnionsByType;
    private final ObjectFlattener<GenericRecord> avroFlattener;
    private final MapInputRowParser mapParser;

    @JsonCreator
    public AvroHadoopInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="fromPigAvroStorage") Boolean fromPigAvroStorage, @JsonProperty(value="binaryAsString") Boolean binaryAsString, @JsonProperty(value="extractUnionsByType") Boolean extractUnionsByType) {
        this.parseSpec = parseSpec;
        this.fromPigAvroStorage = fromPigAvroStorage != null && fromPigAvroStorage != false;
        this.binaryAsString = binaryAsString != null && binaryAsString != false;
        this.extractUnionsByType = extractUnionsByType != null && extractUnionsByType != false;
        this.avroFlattener = AvroParsers.makeFlattener(parseSpec, this.fromPigAvroStorage, this.binaryAsString, this.extractUnionsByType);
        this.mapParser = new MapInputRowParser(parseSpec);
    }

    public List<InputRow> parseBatch(GenericRecord record) {
        return AvroParsers.parseGenericRecord(record, this.mapParser, this.avroFlattener);
    }

    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @JsonProperty
    public boolean isFromPigAvroStorage() {
        return this.fromPigAvroStorage;
    }

    @JsonProperty
    public Boolean getBinaryAsString() {
        return this.binaryAsString;
    }

    @JsonProperty
    public Boolean isExtractUnionsByType() {
        return this.extractUnionsByType;
    }

    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new AvroHadoopInputRowParser(parseSpec, this.fromPigAvroStorage, this.binaryAsString, this.extractUnionsByType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroHadoopInputRowParser that = (AvroHadoopInputRowParser)o;
        return this.fromPigAvroStorage == that.fromPigAvroStorage && this.binaryAsString == that.binaryAsString && this.extractUnionsByType == that.extractUnionsByType && Objects.equals(this.parseSpec, that.parseSpec);
    }

    public int hashCode() {
        return Objects.hash(this.parseSpec, this.fromPigAvroStorage, this.binaryAsString, this.extractUnionsByType);
    }

    public String toString() {
        return "AvroHadoopInputRowParser{parseSpec=" + String.valueOf(this.parseSpec) + ", fromPigAvroStorage=" + this.fromPigAvroStorage + ", binaryAsString=" + this.binaryAsString + ", extractUnionsByType=" + this.extractUnionsByType + "}";
    }
}

