/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.apache.druid.catalog.storage.CatalogStorage;
import org.apache.druid.catalog.sync.CacheNotifier;
import org.apache.druid.catalog.sync.CatalogUpdateListener;
import org.apache.druid.catalog.sync.ListeningNodeSupplier;
import org.apache.druid.catalog.sync.RestUpdateSender;
import org.apache.druid.catalog.sync.UpdateEvent;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.joda.time.Duration;

@ManageLifecycle
public class CatalogUpdateNotifier
implements CatalogUpdateListener {
    private static final EmittingLogger LOG = new EmittingLogger(CatalogUpdateNotifier.class);
    private static final String CALLER_NAME = "Catalog Sync";
    private static final long TIMEOUT_MS = 5000L;
    private final CacheNotifier notifier;
    private final ObjectMapper smileMapper;

    @Inject
    public CatalogUpdateNotifier(CatalogStorage catalog, DruidNodeDiscoveryProvider discoveryProvider, @EscalatedClient HttpClient httpClient, @Smile ObjectMapper smileMapper) {
        long timeoutMs = 5000L;
        this.smileMapper = smileMapper;
        ListeningNodeSupplier nodeSupplier = new ListeningNodeSupplier((List<NodeRole>)ImmutableList.of((Object)NodeRole.BROKER, (Object)NodeRole.OVERLORD), discoveryProvider);
        RestUpdateSender.RestSender restSender = RestUpdateSender.httpClientSender(httpClient, Duration.millis((long)timeoutMs));
        RestUpdateSender sender = new RestUpdateSender(CALLER_NAME, nodeSupplier, restSender, "/druid/broker/v1/catalog/sync", timeoutMs);
        this.notifier = new CacheNotifier(CALLER_NAME, sender);
        catalog.register(this);
    }

    @LifecycleStart
    public void start() {
        this.notifier.start();
        LOG.info("Catalog update notifier started", new Object[0]);
    }

    @LifecycleStop
    public void stop() {
        this.notifier.stop();
        LOG.info("Catalog update notifier stopped", new Object[0]);
    }

    @Override
    public void updated(UpdateEvent event) {
        this.notifier.send(JacksonUtils.toBytes((ObjectMapper)this.smileMapper, (Object)event));
    }

    @Override
    public void flush() {
    }

    @Override
    public void resync() {
    }
}

