/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.authorization.RoleProvider;
import org.apache.druid.security.basic.authorization.db.cache.BasicAuthorizerCacheManager;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRole;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerUser;
import org.apache.druid.server.security.AuthenticationResult;

@JsonTypeName(value="metadata")
public class MetadataStoreRoleProvider
implements RoleProvider {
    private static final Logger LOG = new Logger(MetadataStoreRoleProvider.class);
    private final BasicAuthorizerCacheManager cacheManager;

    @JsonCreator
    public MetadataStoreRoleProvider(@JacksonInject BasicAuthorizerCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public Set<String> getRoles(String authorizerPrefix, AuthenticationResult authenticationResult) {
        HashSet<String> roleNames = new HashSet<String>();
        Map<String, BasicAuthorizerUser> userMap = this.cacheManager.getUserMap(authorizerPrefix);
        if (userMap == null) {
            throw new IAE("Could not load userMap for authorizer [%s]", new Object[]{authorizerPrefix});
        }
        BasicAuthorizerUser user = userMap.get(authenticationResult.getIdentity());
        if (user != null) {
            roleNames.addAll(user.getRoles());
        }
        return roleNames;
    }

    @Override
    public Map<String, BasicAuthorizerRole> getRoleMap(String authorizerPrefix) {
        return this.cacheManager.getRoleMap(authorizerPrefix);
    }
}

