/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerStateBuilder;
import io.kubernetes.client.openapi.models.V1ContainerStateFluentImpl;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1ContainerStatusFluent;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsBuilder;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class V1ContainerStatusFluentImpl<A extends V1ContainerStatusFluent<A>>
extends BaseFluent<A>
implements V1ContainerStatusFluent<A> {
    private Map<String, Quantity> allocatedResources;
    private String containerID;
    private String image;
    private String imageID;
    private V1ContainerStateBuilder lastState;
    private String name;
    private Boolean ready;
    private V1ResourceRequirementsBuilder resources;
    private Integer restartCount;
    private Boolean started;
    private V1ContainerStateBuilder state;

    public V1ContainerStatusFluentImpl() {
    }

    public V1ContainerStatusFluentImpl(V1ContainerStatus instance) {
        if (instance != null) {
            this.withAllocatedResources(instance.getAllocatedResources());
            this.withContainerID(instance.getContainerID());
            this.withImage(instance.getImage());
            this.withImageID(instance.getImageID());
            this.withLastState(instance.getLastState());
            this.withName(instance.getName());
            this.withReady(instance.getReady());
            this.withResources(instance.getResources());
            this.withRestartCount(instance.getRestartCount());
            this.withStarted(instance.getStarted());
            this.withState(instance.getState());
        }
    }

    @Override
    public A addToAllocatedResources(String key, Quantity value) {
        if (this.allocatedResources == null && key != null && value != null) {
            this.allocatedResources = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatedResources.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAllocatedResources(Map<String, Quantity> map) {
        if (this.allocatedResources == null && map != null) {
            this.allocatedResources = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatedResources.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatedResources(String key) {
        if (this.allocatedResources == null) {
            return (A)this;
        }
        if (key != null && this.allocatedResources != null) {
            this.allocatedResources.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatedResources(Map<String, Quantity> map) {
        if (this.allocatedResources == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatedResources == null) continue;
                this.allocatedResources.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    @Override
    public <K, V> A withAllocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources == null ? null : new LinkedHashMap<String, Quantity>(allocatedResources);
        return (A)this;
    }

    @Override
    public Boolean hasAllocatedResources() {
        return this.allocatedResources != null;
    }

    @Override
    public String getContainerID() {
        return this.containerID;
    }

    @Override
    public A withContainerID(String containerID) {
        this.containerID = containerID;
        return (A)this;
    }

    @Override
    public Boolean hasContainerID() {
        return this.containerID != null;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)this;
    }

    @Override
    public Boolean hasImageID() {
        return this.imageID != null;
    }

    @Override
    @Deprecated
    public V1ContainerState getLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    @Override
    public V1ContainerState buildLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    @Override
    public A withLastState(V1ContainerState lastState) {
        this._visitables.get("lastState").remove(this.lastState);
        if (lastState != null) {
            this.lastState = new V1ContainerStateBuilder(lastState);
            this._visitables.get("lastState").add(this.lastState);
        } else {
            this.lastState = null;
            this._visitables.get("lastState").remove(this.lastState);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastState() {
        return this.lastState != null;
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> withNewLastState() {
        return new LastStateNestedImpl();
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(V1ContainerState item) {
        return new LastStateNestedImpl(item);
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> editLastState() {
        return this.withNewLastStateLike(this.getLastState());
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> editOrNewLastState() {
        return this.withNewLastStateLike(this.getLastState() != null ? this.getLastState() : new V1ContainerStateBuilder().build());
    }

    @Override
    public V1ContainerStatusFluent.LastStateNested<A> editOrNewLastStateLike(V1ContainerState item) {
        return this.withNewLastStateLike(this.getLastState() != null ? this.getLastState() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Boolean getReady() {
        return this.ready;
    }

    @Override
    public A withReady(Boolean ready) {
        this.ready = ready;
        return (A)this;
    }

    @Override
    public Boolean hasReady() {
        return this.ready != null;
    }

    @Override
    @Deprecated
    public V1ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public V1ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(V1ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new V1ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public V1ContainerStatusFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public V1ContainerStatusFluent.ResourcesNested<A> withNewResourcesLike(V1ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public V1ContainerStatusFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public V1ContainerStatusFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new V1ResourceRequirementsBuilder().build());
    }

    @Override
    public V1ContainerStatusFluent.ResourcesNested<A> editOrNewResourcesLike(V1ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    public Integer getRestartCount() {
        return this.restartCount;
    }

    @Override
    public A withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return (A)this;
    }

    @Override
    public Boolean hasRestartCount() {
        return this.restartCount != null;
    }

    @Override
    public Boolean getStarted() {
        return this.started;
    }

    @Override
    public A withStarted(Boolean started) {
        this.started = started;
        return (A)this;
    }

    @Override
    public Boolean hasStarted() {
        return this.started != null;
    }

    @Override
    @Deprecated
    public V1ContainerState getState() {
        return this.state != null ? this.state.build() : null;
    }

    @Override
    public V1ContainerState buildState() {
        return this.state != null ? this.state.build() : null;
    }

    @Override
    public A withState(V1ContainerState state) {
        this._visitables.get("state").remove(this.state);
        if (state != null) {
            this.state = new V1ContainerStateBuilder(state);
            this._visitables.get("state").add(this.state);
        } else {
            this.state = null;
            this._visitables.get("state").remove(this.state);
        }
        return (A)this;
    }

    @Override
    public Boolean hasState() {
        return this.state != null;
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> withNewState() {
        return new StateNestedImpl();
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> withNewStateLike(V1ContainerState item) {
        return new StateNestedImpl(item);
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> editState() {
        return this.withNewStateLike(this.getState());
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> editOrNewState() {
        return this.withNewStateLike(this.getState() != null ? this.getState() : new V1ContainerStateBuilder().build());
    }

    @Override
    public V1ContainerStatusFluent.StateNested<A> editOrNewStateLike(V1ContainerState item) {
        return this.withNewStateLike(this.getState() != null ? this.getState() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ContainerStatusFluentImpl that = (V1ContainerStatusFluentImpl)o;
        if (!Objects.equals(this.allocatedResources, that.allocatedResources)) {
            return false;
        }
        if (!Objects.equals(this.containerID, that.containerID)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imageID, that.imageID)) {
            return false;
        }
        if (!Objects.equals(this.lastState, that.lastState)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.ready, that.ready)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.restartCount, that.restartCount)) {
            return false;
        }
        if (!Objects.equals(this.started, that.started)) {
            return false;
        }
        return Objects.equals(this.state, that.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocatedResources, this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.resources, this.restartCount, this.started, this.state, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocatedResources != null && !this.allocatedResources.isEmpty()) {
            sb.append("allocatedResources:");
            sb.append(this.allocatedResources + ",");
        }
        if (this.containerID != null) {
            sb.append("containerID:");
            sb.append(this.containerID + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID + ",");
        }
        if (this.lastState != null) {
            sb.append("lastState:");
            sb.append(this.lastState + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.restartCount != null) {
            sb.append("restartCount:");
            sb.append(this.restartCount + ",");
        }
        if (this.started != null) {
            sb.append("started:");
            sb.append(this.started + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReady() {
        return this.withReady(true);
    }

    @Override
    public A withStarted() {
        return this.withStarted(true);
    }

    class LastStateNestedImpl<N>
    extends V1ContainerStateFluentImpl<V1ContainerStatusFluent.LastStateNested<N>>
    implements V1ContainerStatusFluent.LastStateNested<N>,
    Nested<N> {
        V1ContainerStateBuilder builder;

        LastStateNestedImpl(V1ContainerState item) {
            this.builder = new V1ContainerStateBuilder(this, item);
        }

        LastStateNestedImpl() {
            this.builder = new V1ContainerStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluentImpl.this.withLastState(this.builder.build());
        }

        @Override
        public N endLastState() {
            return this.and();
        }
    }

    class ResourcesNestedImpl<N>
    extends V1ResourceRequirementsFluentImpl<V1ContainerStatusFluent.ResourcesNested<N>>
    implements V1ContainerStatusFluent.ResourcesNested<N>,
    Nested<N> {
        V1ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(V1ResourceRequirements item) {
            this.builder = new V1ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new V1ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    class StateNestedImpl<N>
    extends V1ContainerStateFluentImpl<V1ContainerStatusFluent.StateNested<N>>
    implements V1ContainerStatusFluent.StateNested<N>,
    Nested<N> {
        V1ContainerStateBuilder builder;

        StateNestedImpl(V1ContainerState item) {
            this.builder = new V1ContainerStateBuilder(this, item);
        }

        StateNestedImpl() {
            this.builder = new V1ContainerStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluentImpl.this.withState(this.builder.build());
        }

        @Override
        public N endState() {
            return this.and();
        }
    }
}

