/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha2AllocationResult;
import io.kubernetes.client.openapi.models.V1alpha2AllocationResultBuilder;
import io.kubernetes.client.openapi.models.V1alpha2AllocationResultFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimConsumerReference;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimConsumerReferenceBuilder;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimConsumerReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimStatus;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha2ResourceClaimStatusFluentImpl<A extends V1alpha2ResourceClaimStatusFluent<A>>
extends BaseFluent<A>
implements V1alpha2ResourceClaimStatusFluent<A> {
    private V1alpha2AllocationResultBuilder allocation;
    private Boolean deallocationRequested;
    private String driverName;
    private ArrayList<V1alpha2ResourceClaimConsumerReferenceBuilder> reservedFor;

    public V1alpha2ResourceClaimStatusFluentImpl() {
    }

    public V1alpha2ResourceClaimStatusFluentImpl(V1alpha2ResourceClaimStatus instance) {
        if (instance != null) {
            this.withAllocation(instance.getAllocation());
            this.withDeallocationRequested(instance.getDeallocationRequested());
            this.withDriverName(instance.getDriverName());
            this.withReservedFor(instance.getReservedFor());
        }
    }

    @Override
    @Deprecated
    public V1alpha2AllocationResult getAllocation() {
        return this.allocation != null ? this.allocation.build() : null;
    }

    @Override
    public V1alpha2AllocationResult buildAllocation() {
        return this.allocation != null ? this.allocation.build() : null;
    }

    @Override
    public A withAllocation(V1alpha2AllocationResult allocation) {
        this._visitables.get("allocation").remove(this.allocation);
        if (allocation != null) {
            this.allocation = new V1alpha2AllocationResultBuilder(allocation);
            this._visitables.get("allocation").add(this.allocation);
        } else {
            this.allocation = null;
            this._visitables.get("allocation").remove(this.allocation);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllocation() {
        return this.allocation != null;
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.AllocationNested<A> withNewAllocation() {
        return new AllocationNestedImpl();
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.AllocationNested<A> withNewAllocationLike(V1alpha2AllocationResult item) {
        return new AllocationNestedImpl(item);
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.AllocationNested<A> editAllocation() {
        return this.withNewAllocationLike(this.getAllocation());
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.AllocationNested<A> editOrNewAllocation() {
        return this.withNewAllocationLike(this.getAllocation() != null ? this.getAllocation() : new V1alpha2AllocationResultBuilder().build());
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.AllocationNested<A> editOrNewAllocationLike(V1alpha2AllocationResult item) {
        return this.withNewAllocationLike(this.getAllocation() != null ? this.getAllocation() : item);
    }

    @Override
    public Boolean getDeallocationRequested() {
        return this.deallocationRequested;
    }

    @Override
    public A withDeallocationRequested(Boolean deallocationRequested) {
        this.deallocationRequested = deallocationRequested;
        return (A)this;
    }

    @Override
    public Boolean hasDeallocationRequested() {
        return this.deallocationRequested != null;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    @Override
    public Boolean hasDriverName() {
        return this.driverName != null;
    }

    @Override
    public A addToReservedFor(int index, V1alpha2ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        V1alpha2ResourceClaimConsumerReferenceBuilder builder = new V1alpha2ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").add(index, builder);
            this.reservedFor.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToReservedFor(int index, V1alpha2ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        V1alpha2ResourceClaimConsumerReferenceBuilder builder = new V1alpha2ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").set(index, builder);
            this.reservedFor.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToReservedFor(V1alpha2ResourceClaimConsumerReference ... items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (V1alpha2ResourceClaimConsumerReference item : items) {
            V1alpha2ResourceClaimConsumerReferenceBuilder builder = new V1alpha2ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToReservedFor(Collection<V1alpha2ResourceClaimConsumerReference> items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (V1alpha2ResourceClaimConsumerReference item : items) {
            V1alpha2ResourceClaimConsumerReferenceBuilder builder = new V1alpha2ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromReservedFor(V1alpha2ResourceClaimConsumerReference ... items) {
        for (V1alpha2ResourceClaimConsumerReference item : items) {
            V1alpha2ResourceClaimConsumerReferenceBuilder builder = new V1alpha2ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            if (this.reservedFor == null) continue;
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReservedFor(Collection<V1alpha2ResourceClaimConsumerReference> items) {
        for (V1alpha2ResourceClaimConsumerReference item : items) {
            V1alpha2ResourceClaimConsumerReferenceBuilder builder = new V1alpha2ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            if (this.reservedFor == null) continue;
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromReservedFor(Predicate<V1alpha2ResourceClaimConsumerReferenceBuilder> predicate) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        Iterator<V1alpha2ResourceClaimConsumerReferenceBuilder> each = this.reservedFor.iterator();
        Object visitables = this._visitables.get("reservedFor");
        while (each.hasNext()) {
            V1alpha2ResourceClaimConsumerReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1alpha2ResourceClaimConsumerReference> getReservedFor() {
        return this.reservedFor != null ? V1alpha2ResourceClaimStatusFluentImpl.build(this.reservedFor) : null;
    }

    @Override
    public List<V1alpha2ResourceClaimConsumerReference> buildReservedFor() {
        return this.reservedFor != null ? V1alpha2ResourceClaimStatusFluentImpl.build(this.reservedFor) : null;
    }

    @Override
    public V1alpha2ResourceClaimConsumerReference buildReservedFor(int index) {
        return this.reservedFor.get(index).build();
    }

    @Override
    public V1alpha2ResourceClaimConsumerReference buildFirstReservedFor() {
        return this.reservedFor.get(0).build();
    }

    @Override
    public V1alpha2ResourceClaimConsumerReference buildLastReservedFor() {
        return this.reservedFor.get(this.reservedFor.size() - 1).build();
    }

    @Override
    public V1alpha2ResourceClaimConsumerReference buildMatchingReservedFor(Predicate<V1alpha2ResourceClaimConsumerReferenceBuilder> predicate) {
        for (V1alpha2ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReservedFor(Predicate<V1alpha2ResourceClaimConsumerReferenceBuilder> predicate) {
        for (V1alpha2ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReservedFor(List<V1alpha2ResourceClaimConsumerReference> reservedFor) {
        if (this.reservedFor != null) {
            this._visitables.get("reservedFor").clear();
        }
        if (reservedFor != null) {
            this.reservedFor = new ArrayList();
            for (V1alpha2ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        } else {
            this.reservedFor = null;
        }
        return (A)this;
    }

    @Override
    public A withReservedFor(V1alpha2ResourceClaimConsumerReference ... reservedFor) {
        if (this.reservedFor != null) {
            this.reservedFor.clear();
            this._visitables.remove("reservedFor");
        }
        if (reservedFor != null) {
            for (V1alpha2ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReservedFor() {
        return this.reservedFor != null && !this.reservedFor.isEmpty();
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.ReservedForNested<A> addNewReservedFor() {
        return new ReservedForNestedImpl();
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.ReservedForNested<A> addNewReservedForLike(V1alpha2ResourceClaimConsumerReference item) {
        return new ReservedForNestedImpl(-1, item);
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.ReservedForNested<A> setNewReservedForLike(int index, V1alpha2ResourceClaimConsumerReference item) {
        return new ReservedForNestedImpl(index, item);
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.ReservedForNested<A> editReservedFor(int index) {
        if (this.reservedFor.size() <= index) {
            throw new RuntimeException("Can't edit reservedFor. Index exceeds size.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.ReservedForNested<A> editFirstReservedFor() {
        if (this.reservedFor.size() == 0) {
            throw new RuntimeException("Can't edit first reservedFor. The list is empty.");
        }
        return this.setNewReservedForLike(0, this.buildReservedFor(0));
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.ReservedForNested<A> editLastReservedFor() {
        int index = this.reservedFor.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last reservedFor. The list is empty.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    @Override
    public V1alpha2ResourceClaimStatusFluent.ReservedForNested<A> editMatchingReservedFor(Predicate<V1alpha2ResourceClaimConsumerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.reservedFor.size(); ++i) {
            if (!predicate.test(this.reservedFor.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching reservedFor. No match found.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2ResourceClaimStatusFluentImpl that = (V1alpha2ResourceClaimStatusFluentImpl)o;
        if (!Objects.equals(this.allocation, that.allocation)) {
            return false;
        }
        if (!Objects.equals(this.deallocationRequested, that.deallocationRequested)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        return Objects.equals(this.reservedFor, that.reservedFor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocation, this.deallocationRequested, this.driverName, this.reservedFor, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocation != null) {
            sb.append("allocation:");
            sb.append(this.allocation + ",");
        }
        if (this.deallocationRequested != null) {
            sb.append("deallocationRequested:");
            sb.append(this.deallocationRequested + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.reservedFor != null) {
            sb.append("reservedFor:");
            sb.append(this.reservedFor);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withDeallocationRequested() {
        return this.withDeallocationRequested(true);
    }

    class AllocationNestedImpl<N>
    extends V1alpha2AllocationResultFluentImpl<V1alpha2ResourceClaimStatusFluent.AllocationNested<N>>
    implements V1alpha2ResourceClaimStatusFluent.AllocationNested<N>,
    Nested<N> {
        V1alpha2AllocationResultBuilder builder;

        AllocationNestedImpl(V1alpha2AllocationResult item) {
            this.builder = new V1alpha2AllocationResultBuilder(this, item);
        }

        AllocationNestedImpl() {
            this.builder = new V1alpha2AllocationResultBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClaimStatusFluentImpl.this.withAllocation(this.builder.build());
        }

        @Override
        public N endAllocation() {
            return this.and();
        }
    }

    class ReservedForNestedImpl<N>
    extends V1alpha2ResourceClaimConsumerReferenceFluentImpl<V1alpha2ResourceClaimStatusFluent.ReservedForNested<N>>
    implements V1alpha2ResourceClaimStatusFluent.ReservedForNested<N>,
    Nested<N> {
        V1alpha2ResourceClaimConsumerReferenceBuilder builder;
        int index;

        ReservedForNestedImpl(int index, V1alpha2ResourceClaimConsumerReference item) {
            this.index = index;
            this.builder = new V1alpha2ResourceClaimConsumerReferenceBuilder(this, item);
        }

        ReservedForNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha2ResourceClaimConsumerReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClaimStatusFluentImpl.this.setToReservedFor(this.index, this.builder.build());
        }

        @Override
        public N endReservedFor() {
            return this.and();
        }
    }
}

