/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.portfolio.loanaccount.api.LoanChargesApiResource;
import org.springframework.stereotype.Component;

@Component
public class AdjustChargeCommandStrategy
implements CommandStrategy {
    private final LoanChargesApiResource loanChargesApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)relativeUrl);
        Long loanId = Long.parseLong((String)pathParameters.get(1));
        Pattern commandPattern = Pattern.compile("^?command=[a-zA-Z]+");
        Matcher commandMatcher = commandPattern.matcher((CharSequence)pathParameters.get(3));
        if (!commandMatcher.find()) {
            response.setRequestId(request.getRequestId());
            response.setStatusCode(Integer.valueOf(501));
            response.setBody("Resource with method " + request.getMethod() + " and relativeUrl " + request.getRelativeUrl() + " doesn't exist");
            return response;
        }
        String commandQueryParam = commandMatcher.group(0);
        String command = commandQueryParam.substring(commandQueryParam.indexOf("=") + 1);
        String chargeIdPathParameter = (String)pathParameters.get(3);
        Long loanChargeId = chargeIdPathParameter.contains("?") ? Long.valueOf(Long.parseLong(((String)pathParameters.get(3)).substring(0, ((String)pathParameters.get(3)).indexOf("?")))) : Long.valueOf(Long.parseLong((String)pathParameters.get(3)));
        String responseBody = this.loanChargesApiResource.executeLoanCharge(loanId, loanChargeId, command, request.getBody());
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    @Generated
    public AdjustChargeCommandStrategy(LoanChargesApiResource loanChargesApiResource) {
        this.loanChargesApiResource = loanChargesApiResource;
    }
}

