/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.service;

import java.util.Collection;
import org.apache.fineract.infrastructure.creditbureau.data.CreditBureauLoanProductMappingData;
import org.apache.fineract.infrastructure.creditbureau.service.CreditBureauLoanProductMappingReadPlatformService;
import org.apache.fineract.infrastructure.creditbureau.service.CreditBureauLoanProductMappingReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class CreditBureauLoanProductMappingReadPlatformServiceImpl
implements CreditBureauLoanProductMappingReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Autowired
    public CreditBureauLoanProductMappingReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<CreditBureauLoanProductMappingData> readCreditBureauLoanProductMapping() {
        this.context.authenticatedUser();
        CreditBureauLoanProductMapper rm = new CreditBureauLoanProductMapper();
        String sql = "select " + rm.schema() + " order by cblp.id";
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public CreditBureauLoanProductMappingData readMappingByLoanId(long loanProductId) {
        this.context.authenticatedUser();
        CreditBureauLoanProductMapper rm = new CreditBureauLoanProductMapper();
        String sql = "select " + rm.schema() + " and cblp.loan_product_id=?";
        return (CreditBureauLoanProductMappingData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{loanProductId});
    }

    public Collection<CreditBureauLoanProductMappingData> fetchLoanProducts() {
        this.context.authenticatedUser();
        LoanProductMapper rm = new LoanProductMapper();
        String sql = "select " + rm.schema() + " order by lp.id";
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }
}

