/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.survey.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.survey.data.LikelihoodData;
import org.apache.fineract.infrastructure.survey.service.ReadLikelihoodService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class ReadLikelihoodServiceImpl
implements ReadLikelihoodService {
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    ReadLikelihoodServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<LikelihoodData> retrieveAll(String ppiName) {
        SqlRowSet likelihood = this.getLikelihood(ppiName);
        ArrayList<LikelihoodData> likelihoodDatas = new ArrayList<LikelihoodData>();
        while (likelihood.next()) {
            likelihoodDatas.add(new LikelihoodData().setResourceId(likelihood.getLong("id")).setLikeliHoodName(likelihood.getString("name")).setLikeliHoodCode(likelihood.getString("code")).setEnabled(likelihood.getLong("enabled")));
        }
        return likelihoodDatas;
    }

    private SqlRowSet getLikelihood(String ppiName) {
        String sql = "SELECT lkp.id, lkh.code , lkh.name, lkp.enabled  FROM ppi_poverty_line pl  JOIN ppi_likelihoods_ppi lkp on lkp.id = pl.likelihood_ppi_id  JOIN ppi_likelihoods lkh on lkp.likelihood_id = lkh.id  WHERE lkp.ppi_name = ?  GROUP BY pl.likelihood_ppi_id ";
        return this.jdbcTemplate.queryForRowSet(sql, new Object[]{ppiName});
    }

    public LikelihoodData retrieve(Long likelihoodId) {
        SqlRowSet likelihood = this.getLikelihood(likelihoodId);
        likelihood.first();
        return new LikelihoodData().setResourceId(likelihood.getLong("id")).setLikeliHoodName(likelihood.getString("name")).setLikeliHoodCode(likelihood.getString("code")).setEnabled(likelihood.getLong("enabled"));
    }

    private SqlRowSet getLikelihood(Long likelihoodId) {
        String sql = "SELECT lkp.id, lkh.code , lkh.name, lkp.enabled  FROM ppi_likelihoods lkh  JOIN ppi_likelihoods_ppi lkp on lkp.likelihood_id = lkh.id  WHERE lkp.id = ? ";
        return this.jdbcTemplate.queryForRowSet(sql, new Object[]{likelihoodId});
    }
}

