/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.service;

import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.notification.cache.CacheNotificationResponseHeader;
import org.apache.fineract.notification.data.NotificationData;
import org.apache.fineract.notification.service.NotificationReadPlatformService;
import org.apache.fineract.notification.service.NotificationReadPlatformServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class NotificationReadPlatformServiceImpl
implements NotificationReadPlatformService {
    private HashMap<Long, HashMap<Long, CacheNotificationResponseHeader>> tenantNotificationResponseHeaderCache = new HashMap();
    private final NotificationDataRow notificationDataRow = new NotificationDataRow();
    private final NotificationMapperRow notificationMapperRow = new NotificationMapperRow();
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final ColumnValidator columnValidator;
    private final PaginationHelper paginationHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    public boolean hasUnreadNotifications(Long appUserId) {
        Long tenantId = ThreadLocalContextUtil.getTenant().getId();
        Long now = System.currentTimeMillis() / 1000L;
        if (this.tenantNotificationResponseHeaderCache.containsKey(tenantId)) {
            HashMap notificationResponseHeaderCache = (HashMap)this.tenantNotificationResponseHeaderCache.get(tenantId);
            if (notificationResponseHeaderCache.containsKey(appUserId)) {
                Long lastFetch = ((CacheNotificationResponseHeader)notificationResponseHeaderCache.get(appUserId)).getLastFetch();
                if (now - lastFetch > 1L) {
                    return this.createUpdateCacheValue(appUserId, now, notificationResponseHeaderCache);
                }
                return ((CacheNotificationResponseHeader)notificationResponseHeaderCache.get(appUserId)).hasNotifications();
            }
            return this.createUpdateCacheValue(appUserId, now, notificationResponseHeaderCache);
        }
        return this.initializeTenantNotificationResponseHeaderCache(tenantId, now, appUserId);
    }

    private boolean initializeTenantNotificationResponseHeaderCache(Long tenantId, Long now, Long appUserId) {
        HashMap notificationResponseHeaderCache = new HashMap();
        this.tenantNotificationResponseHeaderCache.put(tenantId, notificationResponseHeaderCache);
        return this.createUpdateCacheValue(appUserId, now, notificationResponseHeaderCache);
    }

    private boolean createUpdateCacheValue(Long appUserId, Long now, HashMap<Long, CacheNotificationResponseHeader> notificationResponseHeaderCache) {
        Long tenantId = ThreadLocalContextUtil.getTenant().getId();
        boolean hasNotifications = this.checkForUnreadNotifications(appUserId);
        CacheNotificationResponseHeader cacheNotificationResponseHeader = new CacheNotificationResponseHeader(hasNotifications, now);
        notificationResponseHeaderCache.put(appUserId, cacheNotificationResponseHeader);
        this.tenantNotificationResponseHeaderCache.put(tenantId, notificationResponseHeaderCache);
        return hasNotifications;
    }

    private boolean checkForUnreadNotifications(Long appUserId) {
        String sql = "SELECT id, notification_id as notificationId, user_id as userId, is_read as isRead, created_at as createdAt FROM notification_mapper WHERE user_id = ? AND is_read = false";
        List notificationMappers = this.jdbcTemplate.query(sql, (RowMapper)this.notificationMapperRow, new Object[]{appUserId});
        return notificationMappers.size() > 0;
    }

    public void updateNotificationReadStatus() {
        Long appUserId = (Long)this.context.authenticatedUser().getId();
        String sql = "UPDATE notification_mapper SET is_read = true WHERE is_read = false and user_id = ?";
        this.jdbcTemplate.update(sql, new Object[]{appUserId});
    }

    public Page<NotificationData> getAllUnreadNotifications(SearchParameters searchParameters) {
        Long appUserId = (Long)this.context.authenticatedUser().getId();
        String sql = "SELECT " + this.sqlGenerator.calcFoundRows() + " ng.id as id, nm.user_id as userId, ng.object_type as objectType, ng.object_identifier as objectId, ng.actor as actor, ng." + this.sqlGenerator.escape("action") + " as action, ng.notification_content as content, ng.is_system_generated as isSystemGenerated, nm.created_at as createdAt FROM notification_mapper nm INNER JOIN notification_generator ng ON nm.notification_id = ng.id WHERE nm.user_id = ? AND nm.is_read = false order by nm.created_at desc";
        return this.getNotificationDataPage(searchParameters, appUserId, sql);
    }

    public Page<NotificationData> getAllNotifications(SearchParameters searchParameters) {
        Long appUserId = (Long)this.context.authenticatedUser().getId();
        String sql = "SELECT " + this.sqlGenerator.calcFoundRows() + " ng.id as id, nm.user_id as userId, ng.object_type as objectType, ng.object_identifier as objectId, ng.actor as actor, ng." + this.sqlGenerator.escape("action") + " as action, ng.notification_content as content, ng.is_system_generated as isSystemGenerated, nm.created_at as createdAt FROM notification_mapper nm INNER JOIN notification_generator ng ON nm.notification_id = ng.id WHERE nm.user_id = ? order by nm.created_at desc";
        return this.getNotificationDataPage(searchParameters, appUserId, sql);
    }

    private Page<NotificationData> getNotificationDataPage(SearchParameters searchParameters, Long appUserId, String sql) {
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append(sql);
        if (searchParameters.hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        Object[] params = new Object[]{appUserId};
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), params, (RowMapper)this.notificationDataRow);
    }

    @Generated
    public NotificationReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, ColumnValidator columnValidator, PaginationHelper paginationHelper, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.columnValidator = columnValidator;
        this.paginationHelper = paginationHelper;
        this.sqlGenerator = sqlGenerator;
    }
}

