/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.interestratechart.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.interestratechart.data.InterestIncentiveDataValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InterestRateChartSlabDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final InterestIncentiveDataValidator interestIncentiveDataValidator;
    private static final Set<String> INTERESTRATE_CHART_SLAB_CREATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "id", "description", "periodType", "fromPeriod", "toPeriod", "amountRangeFrom", "amountRangeTo", "annualInterestRate", "currencyCode", "incentives"));
    private static final Set<String> INTERESTRATE_CHART_SLAB_UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "id", "description", "periodType", "fromPeriod", "toPeriod", "amountRangeFrom", "amountRangeTo", "annualInterestRate", "currencyCode", "incentives"));

    @Autowired
    public InterestRateChartSlabDataValidator(FromJsonHelper fromApiJsonHelper, InterestIncentiveDataValidator interestIncentiveDataValidator) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.interestIncentiveDataValidator = interestIncentiveDataValidator;
    }

    public void validateCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)INTERESTRATE_CHART_SLAB_CREATE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("chartslab");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        JsonObject objectElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(objectElement);
        String currencyCode = this.fromApiJsonHelper.extractStringNamed("currencyCode", element);
        baseDataValidator.reset().parameter("currencyCode").value((Object)currencyCode).notBlank().notExceedingLengthOf(Integer.valueOf(3));
        Boolean isPrimaryGroupingByAmount = null;
        this.validateChartSlabsCreate(element, baseDataValidator, locale, isPrimaryGroupingByAmount);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateChartSlabsCreate(JsonElement element, DataValidatorBuilder baseDataValidator, Locale locale, Boolean isPrimaryGroupingByAmount) {
        if (this.fromApiJsonHelper.parameterExists("description", element)) {
            String description = this.fromApiJsonHelper.extractStringNamed("description", element);
            baseDataValidator.reset().parameter("description").value((Object)description).notNull();
        }
        Integer periodType = this.fromApiJsonHelper.extractIntegerNamed("periodType", element, locale);
        if (this.fromApiJsonHelper.parameterExists("periodType", element)) {
            baseDataValidator.reset().parameter("periodType").value((Object)periodType).isOneOfTheseValues(PeriodFrequencyType.integerValues());
        }
        Integer toPeriod = null;
        Integer fromPeriod = this.fromApiJsonHelper.extractIntegerNamed("fromPeriod", element, locale);
        if (this.fromApiJsonHelper.parameterExists("fromPeriod", element)) {
            baseDataValidator.reset().parameter("fromPeriod").value((Object)fromPeriod).integerZeroOrGreater();
        }
        if (isPrimaryGroupingByAmount != null && !isPrimaryGroupingByAmount.booleanValue() || periodType != null || fromPeriod != null) {
            baseDataValidator.reset().parameter("periodType").value((Object)periodType).notNull();
            baseDataValidator.reset().parameter("fromPeriod").value((Object)fromPeriod).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("toPeriod", element)) {
            toPeriod = this.fromApiJsonHelper.extractIntegerNamed("toPeriod", element, locale);
            baseDataValidator.reset().parameter("toPeriod").value((Object)toPeriod).integerGreaterThanZero();
        }
        if (fromPeriod != null && toPeriod != null && fromPeriod > toPeriod) {
            baseDataValidator.parameter("fromPeriod").value((Object)fromPeriod).failWithCode("fromperiod.greater.than.to.period", new Object[0]);
        }
        BigDecimal amountRangeFrom = this.fromApiJsonHelper.extractBigDecimalNamed("amountRangeFrom", element, locale);
        BigDecimal amountRangeTo = this.fromApiJsonHelper.extractBigDecimalNamed("amountRangeTo", element, locale);
        if (this.fromApiJsonHelper.parameterExists("amountRangeFrom", element)) {
            baseDataValidator.reset().parameter("amountRangeFrom").value((Object)amountRangeFrom).zeroOrPositiveAmount();
            if (isPrimaryGroupingByAmount != null && isPrimaryGroupingByAmount.booleanValue()) {
                baseDataValidator.reset().parameter("amountRangeFrom").value((Object)amountRangeFrom).notNull();
            }
        }
        if (this.fromApiJsonHelper.parameterExists("amountRangeTo", element)) {
            baseDataValidator.reset().parameter("amountRangeTo").value((Object)amountRangeTo).positiveAmount();
        }
        if (amountRangeFrom == null && fromPeriod == null) {
            baseDataValidator.failWithCodeNoParameterAddedToErrorCode("fromperiod.or.amountRangeFrom.required", new Object[0]);
        }
        if (amountRangeFrom != null && amountRangeTo != null && amountRangeFrom.compareTo(amountRangeTo) > 0) {
            baseDataValidator.parameter("amountRangeFrom").value((Object)fromPeriod).failWithCode("from.amount.greater.than.to.amount", new Object[0]);
        }
        BigDecimal annualInterestRate = this.fromApiJsonHelper.extractBigDecimalNamed("annualInterestRate", element, locale);
        baseDataValidator.reset().parameter("annualInterestRate").value((Object)annualInterestRate).notNull().zeroOrPositiveAmount();
        this.validateIncentives(element, baseDataValidator, locale);
    }

    public void validateUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)INTERESTRATE_CHART_SLAB_UPDATE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("chartslab");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        JsonObject objectElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(objectElement);
        Boolean isPrimaryGroupingByAmount = null;
        this.validateChartSlabsUpdate(element, baseDataValidator, locale, isPrimaryGroupingByAmount);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateChartSlabsUpdate(JsonElement element, DataValidatorBuilder baseDataValidator, Locale locale, Boolean isPrimaryGroupingByAmount) {
        if (this.fromApiJsonHelper.parameterExists("description", element)) {
            String description = this.fromApiJsonHelper.extractStringNamed("description", element);
            baseDataValidator.reset().parameter("description").value((Object)description).ignoreIfNull();
        }
        if (this.fromApiJsonHelper.parameterExists("periodType", element)) {
            Integer periodType = this.fromApiJsonHelper.extractIntegerNamed("periodType", element, locale);
            baseDataValidator.reset().parameter("periodType").value((Object)periodType).isOneOfTheseValues(PeriodFrequencyType.integerValues());
            if (isPrimaryGroupingByAmount != null && !isPrimaryGroupingByAmount.booleanValue()) {
                baseDataValidator.reset().parameter("periodType").value((Object)periodType).notNull();
            }
        }
        Integer fromPeriod = null;
        Integer toPeriod = null;
        if (this.fromApiJsonHelper.parameterExists("fromPeriod", element)) {
            fromPeriod = this.fromApiJsonHelper.extractIntegerNamed("fromPeriod", element, locale);
            baseDataValidator.reset().parameter("fromPeriod").value((Object)fromPeriod).integerZeroOrGreater();
            if (isPrimaryGroupingByAmount != null && !isPrimaryGroupingByAmount.booleanValue()) {
                baseDataValidator.reset().parameter("fromPeriod").value((Object)fromPeriod).notNull();
            }
        }
        if (this.fromApiJsonHelper.parameterExists("toPeriod", element)) {
            toPeriod = this.fromApiJsonHelper.extractIntegerNamed("toPeriod", element, locale);
            baseDataValidator.reset().parameter("toPeriod").value((Object)toPeriod).integerGreaterThanZero();
        }
        if (fromPeriod != null && toPeriod != null && fromPeriod > toPeriod) {
            baseDataValidator.parameter("fromPeriod").value((Object)fromPeriod).failWithCode("fromperiod.greater.than.toperiod", new Object[0]);
        }
        BigDecimal amountRangeFrom = null;
        BigDecimal amountRangeTo = null;
        if (this.fromApiJsonHelper.parameterExists("amountRangeFrom", element)) {
            amountRangeFrom = this.fromApiJsonHelper.extractBigDecimalNamed("amountRangeFrom", element, locale);
            baseDataValidator.reset().parameter("amountRangeFrom").value((Object)amountRangeFrom).zeroOrPositiveAmount();
            if (isPrimaryGroupingByAmount != null && isPrimaryGroupingByAmount.booleanValue()) {
                baseDataValidator.reset().parameter("amountRangeFrom").value((Object)amountRangeFrom).notNull();
            }
        }
        if (this.fromApiJsonHelper.parameterExists("amountRangeTo", element)) {
            amountRangeTo = this.fromApiJsonHelper.extractBigDecimalNamed("amountRangeTo", element, locale);
            baseDataValidator.reset().parameter("amountRangeTo").value((Object)amountRangeTo).positiveAmount();
        }
        if (amountRangeFrom != null && amountRangeTo != null && amountRangeFrom.compareTo(amountRangeTo) > 0) {
            baseDataValidator.parameter("fromPeriod").value((Object)fromPeriod).failWithCode("fromperiod.greater.than.toperiod", new Object[0]);
        }
        if (this.fromApiJsonHelper.parameterExists("annualInterestRate", element)) {
            BigDecimal annualInterestRate = this.fromApiJsonHelper.extractBigDecimalNamed("annualInterestRate", element, locale);
            baseDataValidator.reset().parameter("annualInterestRate").value((Object)annualInterestRate).notNull().zeroOrPositiveAmount();
        }
        if (this.fromApiJsonHelper.parameterExists("currencyCode", element)) {
            String currencyCode = this.fromApiJsonHelper.extractStringNamed("currencyCode", element);
            baseDataValidator.reset().parameter("currencyCode").value((Object)currencyCode).notBlank().notExceedingLengthOf(Integer.valueOf(3));
        }
        this.validateIncentives(element, baseDataValidator, locale);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateIncentives(JsonElement element, DataValidatorBuilder baseDataValidator, Locale locale) {
        JsonObject topLevelJsonElement;
        if (element.isJsonObject() && (topLevelJsonElement = element.getAsJsonObject()).has("incentives") && topLevelJsonElement.get("incentives").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("incentives").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject incentiveElement = array.get(i).getAsJsonObject();
                if (this.fromApiJsonHelper.parameterExists("id", (JsonElement)incentiveElement)) {
                    Long id = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)incentiveElement);
                    baseDataValidator.reset().parameter("id").value((Object)id).notNull().integerGreaterThanZero();
                    this.interestIncentiveDataValidator.validateIncentiveUpdate((JsonElement)incentiveElement, baseDataValidator, locale);
                    continue;
                }
                this.interestIncentiveDataValidator.validateIncentiveCreate((JsonElement)incentiveElement, baseDataValidator, locale);
            }
        }
    }
}

