/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeBalance;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.util.BuyDownFeeAmortizationUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BuyDownFeeAmortizationUtil {
    private BuyDownFeeAmortizationUtil() {
    }

    public static Money calculateTotalAmortizationTillDate(LoanBuyDownFeeBalance buyDownFeeBalance, List<LoanTransaction> adjustmentTransactions, LocalDate maturityDate, LoanBuyDownFeeStrategy buyDownFeeStrategy, LocalDate tillDate, MonetaryCurrency currency) {
        switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanBuyDownFeeStrategy[buyDownFeeStrategy.ordinal()]) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: 
        }
        return BuyDownFeeAmortizationUtil.calculateTotalAmortizationTillDateEqualAmortization((LoanBuyDownFeeBalance)buyDownFeeBalance, adjustmentTransactions, (LocalDate)maturityDate, (LocalDate)tillDate, (MonetaryCurrency)currency);
    }

    private static Money calculateTotalAmortizationTillDateEqualAmortization(LoanBuyDownFeeBalance balance, List<LoanTransaction> adjustmentTransactions, LocalDate maturityDate, LocalDate tillDate, MonetaryCurrency currency) {
        BigDecimal unrecognizedAmount = balance.getAmount();
        BigDecimal totalAmortizationAmount = BigDecimal.ZERO;
        BigDecimal overAmortizationCorrection = BigDecimal.ZERO;
        List<LoanTransaction> sortedAdjustmentTransactions = adjustmentTransactions.stream().sorted(Comparator.comparing(LoanTransaction::getDateOf)).toList();
        LocalDate periodStart = balance.getDate();
        for (LoanTransaction adjustmentTransaction : sortedAdjustmentTransactions) {
            long daysUntilMaturity = DateUtils.getDifferenceInDays((LocalDate)periodStart, (LocalDate)maturityDate);
            long daysOfPeriod = DateUtils.getDifferenceInDays((LocalDate)periodStart, (LocalDate)adjustmentTransaction.getDateOf());
            BigDecimal periodAmortization = daysUntilMaturity == 0L ? BigDecimal.ZERO : unrecognizedAmount.multiply(BigDecimal.valueOf(daysOfPeriod)).divide(BigDecimal.valueOf(daysUntilMaturity), MoneyHelper.getMathContext());
            totalAmortizationAmount = totalAmortizationAmount.add(periodAmortization);
            if (MathUtil.isLessThanZero((BigDecimal)(unrecognizedAmount = unrecognizedAmount.subtract(periodAmortization).subtract(adjustmentTransaction.getAmount())))) {
                overAmortizationCorrection = overAmortizationCorrection.add(unrecognizedAmount);
                unrecognizedAmount = BigDecimal.ZERO;
            }
            periodStart = adjustmentTransaction.getDateOf();
        }
        if (periodStart.isBefore(tillDate)) {
            long daysUntilMaturity = DateUtils.getDifferenceInDays((LocalDate)periodStart, (LocalDate)maturityDate);
            long daysOfPeriod = DateUtils.getDifferenceInDays((LocalDate)periodStart, (LocalDate)tillDate);
            BigDecimal periodAmortization = unrecognizedAmount.multiply(BigDecimal.valueOf(daysOfPeriod)).divide(BigDecimal.valueOf(daysUntilMaturity), MoneyHelper.getMathContext());
            totalAmortizationAmount = totalAmortizationAmount.add(periodAmortization);
        } else if (balance.getDate().equals(maturityDate)) {
            totalAmortizationAmount = totalAmortizationAmount.add(unrecognizedAmount);
        }
        return Money.of((MonetaryCurrency)currency, (BigDecimal)totalAmortizationAmount.add(overAmortizationCorrection));
    }
}

