/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.fineract.client.models.TaxComponentData;
import org.apache.fineract.client.models.TaxGroupMappingsData;

public class TaxGroupData {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Long id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TAX_ASSOCIATIONS = "taxAssociations";
    @SerializedName(value="taxAssociations")
    private List<TaxGroupMappingsData> taxAssociations;
    public static final String SERIALIZED_NAME_TAX_COMPONENTS = "taxComponents";
    @SerializedName(value="taxComponents")
    private List<TaxComponentData> taxComponents;

    public TaxGroupData id(Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TaxGroupData name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaxGroupData taxAssociations(List<TaxGroupMappingsData> taxAssociations) {
        this.taxAssociations = taxAssociations;
        return this;
    }

    public TaxGroupData addTaxAssociationsItem(TaxGroupMappingsData taxAssociationsItem) {
        if (this.taxAssociations == null) {
            this.taxAssociations = new ArrayList<TaxGroupMappingsData>();
        }
        this.taxAssociations.add(taxAssociationsItem);
        return this;
    }

    @Nullable
    public List<TaxGroupMappingsData> getTaxAssociations() {
        return this.taxAssociations;
    }

    public void setTaxAssociations(List<TaxGroupMappingsData> taxAssociations) {
        this.taxAssociations = taxAssociations;
    }

    public TaxGroupData taxComponents(List<TaxComponentData> taxComponents) {
        this.taxComponents = taxComponents;
        return this;
    }

    public TaxGroupData addTaxComponentsItem(TaxComponentData taxComponentsItem) {
        if (this.taxComponents == null) {
            this.taxComponents = new ArrayList<TaxComponentData>();
        }
        this.taxComponents.add(taxComponentsItem);
        return this;
    }

    @Nullable
    public List<TaxComponentData> getTaxComponents() {
        return this.taxComponents;
    }

    public void setTaxComponents(List<TaxComponentData> taxComponents) {
        this.taxComponents = taxComponents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxGroupData taxGroupData = (TaxGroupData)o;
        return Objects.equals(this.id, taxGroupData.id) && Objects.equals(this.name, taxGroupData.name) && Objects.equals(this.taxAssociations, taxGroupData.taxAssociations) && Objects.equals(this.taxComponents, taxGroupData.taxComponents);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.taxAssociations, this.taxComponents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxGroupData {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    taxAssociations: ").append(this.toIndentedString(this.taxAssociations)).append("\n");
        sb.append("    taxComponents: ").append(this.toIndentedString(this.taxComponents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

