/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class Signature {
    private final List<Argument> arguments;

    private Signature(List<Argument> arguments) {
        this.arguments = (List)Preconditions.checkNotNull(arguments, (String)"Argument must not be null.");
    }

    public static Signature of(Argument ... arguments) {
        return new Signature(Arrays.asList(arguments));
    }

    public static Signature of(List<Argument> arguments) {
        return new Signature(arguments);
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    @PublicEvolving
    public static final class Argument {
        @Nullable
        private final String name;
        private final String type;

        private Argument(@Nullable String name, String type) {
            this.name = name;
            this.type = (String)Preconditions.checkNotNull((Object)type);
        }

        public static Argument of(String name, String type) {
            return new Argument(name, type);
        }

        public static Argument of(String name, LogicalType type) {
            return Argument.of(name, type.asSummaryString());
        }

        public static Argument ofVarying(String name, String type) {
            return new Argument(name, type + "...");
        }

        public static Argument of(String type) {
            return new Argument(null, type);
        }

        public static Argument of(LogicalType type) {
            return Argument.of(type.asSummaryString());
        }

        public static Argument ofVarying(String type) {
            return new Argument(null, type + "...");
        }

        public static Argument ofGroup(String name, String typeGroup) {
            return new Argument(name, "<" + typeGroup + ">");
        }

        public static Argument ofGroup(String name, LogicalTypeRoot typeRoot) {
            return Argument.ofGroup(name, typeRoot.name());
        }

        public static Argument ofGroup(String name, LogicalTypeFamily typeFamily) {
            return Argument.ofGroup(name, typeFamily.name());
        }

        public static Argument ofGroup(String name, Class<? extends Enum<? extends TableSymbol>> symbol) {
            return Argument.ofGroup(name, symbol.getSimpleName());
        }

        public static Argument ofGroupVarying(String name, String typeGroup) {
            return new Argument(name, "<" + typeGroup + ">...");
        }

        public static Argument ofGroup(String typeGroup) {
            return Argument.ofGroup(null, typeGroup);
        }

        public static Argument ofGroup(LogicalTypeRoot typeRoot) {
            return Argument.ofGroup(typeRoot.name());
        }

        public static Argument ofGroup(LogicalTypeFamily typeFamily) {
            return Argument.ofGroup(typeFamily.name());
        }

        public static Argument ofGroup(Class<? extends Enum<? extends TableSymbol>> symbol) {
            return Argument.ofGroup(symbol.getSimpleName());
        }

        public static Argument ofGroupVarying(String typeGroup) {
            return new Argument(null, "<" + typeGroup + ">...");
        }

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public String getType() {
            return this.type;
        }
    }
}

