/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table.lookup.fullcache.inputformat;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.CacheLoader;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.inputformat.InputSplitCacheLoadTask;
import org.apache.flink.table.runtime.keyselector.GenericRowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFormatCacheLoader
extends CacheLoader {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(InputFormatCacheLoader.class);
    private final InputFormat<RowData, InputSplit> initialInputFormat;
    private final GenericRowDataKeySelector keySelector;
    private final RowDataSerializer cacheEntriesSerializer;
    private transient Configuration parameters;

    public InputFormatCacheLoader(InputFormat<RowData, ?> initialInputFormat, GenericRowDataKeySelector keySelector, RowDataSerializer cacheEntriesSerializer) {
        this.initialInputFormat = initialInputFormat;
        this.keySelector = keySelector;
        this.cacheEntriesSerializer = cacheEntriesSerializer;
    }

    @Override
    public void open(Configuration parameters, ClassLoader userCodeClassLoader) throws Exception {
        super.open(parameters, userCodeClassLoader);
        this.parameters = parameters;
        this.initialInputFormat.configure(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean updateCache() throws Exception {
        InputSplit[] inputSplits = this.createInputSplits();
        int numSplits = inputSplits.length;
        int concurrencyLevel = this.getConcurrencyLevel(numSplits);
        ConcurrentHashMap newCache = new ConcurrentHashMap(16, 0.75f, concurrencyLevel);
        Deque cacheLoadTasks = Arrays.stream(inputSplits).map(split -> this.createCacheLoadTask((InputSplit)split, newCache)).collect(Collectors.toCollection(ArrayDeque::new));
        ExecutorService cacheLoadTaskService = null;
        boolean wasInterrupted = false;
        try {
            InputSplitCacheLoadTask firstTask = (InputSplitCacheLoadTask)cacheLoadTasks.pop();
            CompletableFuture<Void> otherTasksFuture = null;
            if (!cacheLoadTasks.isEmpty()) {
                ExecutorService finalExecutor = cacheLoadTaskService = Executors.newFixedThreadPool(concurrencyLevel - 1);
                CompletableFuture[] futures = (CompletableFuture[])cacheLoadTasks.stream().map(task -> CompletableFuture.runAsync(task, finalExecutor)).toArray(CompletableFuture[]::new);
                otherTasksFuture = CompletableFuture.allOf(futures);
            }
            firstTask.run();
            if (otherTasksFuture != null) {
                otherTasksFuture.get();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        finally {
            wasInterrupted = Thread.interrupted();
            if (cacheLoadTaskService != null) {
                cacheLoadTaskService.shutdownNow();
                if (!cacheLoadTaskService.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                    LOG.error("ExecutorService with InputSplit cache loading tasks was not terminated in timeout of {} ms.", (Object)10000L);
                }
            }
        }
        this.cache = newCache;
        return !wasInterrupted;
    }

    private InputSplitCacheLoadTask createCacheLoadTask(InputSplit inputSplit, ConcurrentHashMap<RowData, Collection<RowData>> newCache) {
        try {
            InputFormat inputFormat = (InputFormat)InstantiationUtil.clone(this.initialInputFormat);
            inputFormat.configure(this.parameters);
            return new InputSplitCacheLoadTask(newCache, this.keySelector.copy(), this.cacheEntriesSerializer, (InputFormat<RowData, InputSplit>)inputFormat, inputSplit);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create InputFormatCacheLoadTask", e);
        }
    }

    private InputSplit[] createInputSplits() throws IOException {
        Object[] inputSplits = this.initialInputFormat.createInputSplits(1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("InputFormat created {} InputSplits: {}", (Object)inputSplits.length, (Object)Arrays.deepToString(inputSplits));
        }
        Preconditions.checkState((inputSplits.length >= 1 ? 1 : 0) != 0, (Object)"InputFormat must provide at least one input split to load data into the lookup 'FULL' cache.");
        return inputSplits;
    }

    private int getConcurrencyLevel(int numSplits) {
        int numOfCores = Runtime.getRuntime().availableProcessors();
        return Math.min(numSplits, numOfCores);
    }
}

