/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.result;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.StatementResult;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.result.DynamicResult;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.CloseableIterator;

public abstract class CollectResultBase
implements DynamicResult {
    private final CloseableIterator<RowData> resultIterator;
    protected final Object resultLock;
    protected AtomicReference<SqlExecutionException> executionException = new AtomicReference();
    protected final ResultRetrievalThread retrievalThread;

    public CollectResultBase(StatementResult tableResult) {
        this.resultIterator = tableResult;
        this.resultLock = new Object();
        this.retrievalThread = new ResultRetrievalThread();
    }

    @Override
    public void close() {
        this.retrievalThread.isRunning = false;
        this.retrievalThread.interrupt();
        try {
            this.resultIterator.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected <T> TypedResult<T> handleMissingResult() {
        if (this.executionException.get() != null) {
            throw this.executionException.get();
        }
        return TypedResult.endOfStream();
    }

    protected abstract void processRecord(RowData var1);

    protected boolean isRetrieving() {
        return this.retrievalThread.isRunning;
    }

    protected class ResultRetrievalThread
    extends Thread {
        public volatile boolean isRunning = true;

        protected ResultRetrievalThread() {
        }

        @Override
        public void run() {
            try {
                while (this.isRunning && CollectResultBase.this.resultIterator.hasNext()) {
                    CollectResultBase.this.processRecord((RowData)CollectResultBase.this.resultIterator.next());
                }
            }
            catch (RuntimeException e) {
                CollectResultBase.this.executionException.compareAndSet(null, new SqlExecutionException("Error while retrieving result.", e));
            }
            this.isRunning = false;
        }
    }
}

