/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdNonCumulativeCost$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkRuleSetProgram;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.util.Preconditions;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3Aa\u0002\u0005\u00013!)Q\u0006\u0001C\u0001]!9\u0001\u0007\u0001a\u0001\n#\t\u0004bB \u0001\u0001\u0004%\t\u0002\u0011\u0005\u0007\r\u0002\u0001\u000b\u0015\u0002\u001a\t\u000b-\u0001A\u0011I$\t\u000bI\u0003A\u0011A*\u0003'\u0019c\u0017N\\6W_2\u001c\u0017M\\8Qe><'/Y7\u000b\u0005%Q\u0011a\u00029s_\u001e\u0014\u0018-\u001c\u0006\u0003\u00171\t\u0001b\u001c9uS6L'0\u001a\u0006\u0003\u001b9\tA\u0001\u001d7b]*\u0011q\u0002E\u0001\ba2\fgN\\3s\u0015\t\t\"#A\u0003uC\ndWM\u0003\u0002\u0014)\u0005)a\r\\5oW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001)\"AG\u0011\u0014\u0005\u0001Y\u0002c\u0001\u000f\u001e?5\t\u0001\"\u0003\u0002\u001f\u0011\t\u0019b\t\\5oWJ+H.Z*fiB\u0013xn\u001a:b[B\u0011\u0001%\t\u0007\u0001\t\u0015\u0011\u0003A1\u0001$\u0005\ty5)\u0005\u0002%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t9aj\u001c;iS:<\u0007C\u0001\u000f,\u0013\ta\u0003B\u0001\u000bGY&t7n\u00149uS6L'0Z\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u00022\u0001\b\u0001 \u0003Q\u0011X-];je\u0016$w*\u001e;qkR$&/Y5ugV\t!\u0007E\u0002&gUJ!\u0001\u000e\u0014\u0003\r=\u0003H/[8o!\r)c\u0007O\u0005\u0003o\u0019\u0012Q!\u0011:sCf\u0004\"!O\u001f\u000e\u0003iR!!D\u001e\u000b\u0005q\"\u0012aB2bY\u000eLG/Z\u0005\u0003}i\u0012\u0001BU3m)J\f\u0017\u000e^\u0001\u0019e\u0016\fX/\u001b:fI>+H\u000f];u)J\f\u0017\u000e^:`I\u0015\fHCA!E!\t)#)\u0003\u0002DM\t!QK\\5u\u0011\u001d)5!!AA\u0002I\n1\u0001\u001f\u00132\u0003U\u0011X-];je\u0016$w*\u001e;qkR$&/Y5ug\u0002\"2\u0001\u0013(Q!\tIE*D\u0001K\u0015\tY5(A\u0002sK2L!!\u0014&\u0003\u000fI+GNT8eK\")q*\u0002a\u0001\u0011\u0006!!o\\8u\u0011\u0015\tV\u00011\u0001 \u0003\u001d\u0019wN\u001c;fqR\fqc]3u%\u0016\fX/\u001b:fI>+H\u000f];u)J\f\u0017\u000e^:\u0015\u0005\u0005#\u0006\"B+\u0007\u0001\u0004)\u0014!\u0003:fYR\u0013\u0018-\u001b;t\u0001")
public class FlinkVolcanoProgram<OC extends FlinkOptimizeContext>
extends FlinkRuleSetProgram<OC> {
    private Option<RelTrait[]> requiredOutputTraits = None$.MODULE$;

    public Option<RelTrait[]> requiredOutputTraits() {
        return this.requiredOutputTraits;
    }

    public void requiredOutputTraits_$eq(Option<RelTrait[]> x$1) {
        this.requiredOutputTraits = x$1;
    }

    @Override
    public RelNode optimize(RelNode root, OC context) {
        RelNode relNode;
        if (this.rules().isEmpty()) {
            return root;
        }
        if (this.requiredOutputTraits().isEmpty()) {
            throw new TableException("Required output traits should not be None in FlinkVolcanoProgram");
        }
        RelTraitSet targetTraits = root.getTraitSet().plusAll((RelTrait[])this.requiredOutputTraits().get()).simplify();
        VolcanoPlanner planner = (VolcanoPlanner)root.getCluster().getPlanner();
        Program optProgram = Programs.ofRules(this.rules());
        try {
            try {
                FlinkRelMdNonCumulativeCost$.MODULE$.THREAD_PLANNER().set(planner);
                relNode = optProgram.run(planner, root, targetTraits, ImmutableList.of(), ImmutableList.of());
            }
            catch (Throwable throwable) {
                RuntimeException runtimeException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof RelOptPlanner.CannotPlanException) {
                    RelOptPlanner.CannotPlanException cannotPlanException = (RelOptPlanner.CannotPlanException)throwable2;
                    throw new TableException(new StringBuilder(215).append("Cannot generate a valid execution plan for the given query: \n\n").append(FlinkRelOptUtil$.MODULE$.toString(root, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7())).append("\n").append("This exception indicates that the query uses an unsupported SQL feature.\n").append("Please check the documentation for the set of currently supported SQL features.").toString(), (Throwable)cannotPlanException);
                }
                if (throwable2 instanceof TableException) {
                    TableException tableException = (TableException)throwable2;
                    throw new TableException(new StringBuilder(143).append("Cannot generate a valid execution plan for the given query: \n\n").append(FlinkRelOptUtil$.MODULE$.toString(root, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7())).append("\n").append(tableException.getMessage()).append("\n").append("Please check the documentation for the set of currently supported SQL features.").toString(), (Throwable)tableException);
                }
                if (throwable2 instanceof AssertionError) {
                    AssertionError assertionError = (AssertionError)((Object)throwable2);
                    throw new AssertionError(new StringBuilder(35).append("Sql optimization: Assertion error: ").append(((Throwable)((Object)assertionError)).getMessage()).toString(), (Throwable)((Object)assertionError));
                }
                if (throwable2 instanceof RuntimeException && (runtimeException = (RuntimeException)throwable2).getCause() instanceof TableException) {
                    throw new TableException(new StringBuilder(161).append("Sql optimization: Cannot generate a valid execution plan for the given query: \n\n").append(FlinkRelOptUtil$.MODULE$.toString(root, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7())).append("\n").append(runtimeException.getCause().getMessage()).append("\n").append("Please check the documentation for the set of currently supported SQL features.").toString(), runtimeException.getCause());
                }
                throw throwable;
            }
        }
        finally {
            FlinkRelMdNonCumulativeCost$.MODULE$.THREAD_PLANNER().remove();
        }
        return relNode;
    }

    public void setRequiredOutputTraits(RelTrait[] relTraits) {
        Preconditions.checkNotNull((Object)relTraits);
        this.requiredOutputTraits_$eq((Option<RelTrait[]>)new Some((Object)relTraits));
    }
}

