/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.kubernetes.operator.api.bluegreen;

/** Enum representing different types of differences in Blue/Green deployment specifications. */
public enum BlueGreenDiffType {
    /** No changes detected, should be ignored. */
    IGNORE,

    /** Changes that require a Blue/Green transition. */
    TRANSITION,

    /** Changes that only affect the child FlinkDeploymentSpec. */
    PATCH_CHILD,

    /**
     * Full redeploy from user-specified savepoint. Triggered when savepointRedeployNonce changes.
     * Uses the initialSavepointPath from spec instead of taking a new savepoint.
     */
    SAVEPOINT_REDEPLOY,

    /**
     * In-place suspension. Triggered when job.state changes from RUNNING to SUSPENDED. Suspends the
     * currently active child without creating a new deployment.
     */
    SUSPEND,

    /**
     * Resume from suspension. Triggered when job.state changes from SUSPENDED to RUNNING. Spins up
     * the child with the current (potentially updated) spec.
     */
    RESUME
}
