/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;

public class ConnectExceptions
extends GemFireCheckedException {
    private static final long serialVersionUID = -4173688946448867706L;
    private final List<Throwable> causes = new ArrayList<Throwable>();
    private final List<InternalDistributedMember> members = new ArrayList<InternalDistributedMember>();

    public ConnectExceptions() {
        super("Could not connect");
    }

    public void addFailure(InternalDistributedMember member, Throwable cause) {
        this.members.add(member);
        this.causes.add(cause);
    }

    public List<InternalDistributedMember> getMembers() {
        return this.members;
    }

    public List<Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        for (InternalDistributedMember member : this.members) {
            sb.append(' ').append(member);
        }
        sb.append(" ").append("Causes:");
        for (Throwable cause : this.causes) {
            sb.append(" {").append(cause).append("}");
        }
        return String.format("Could not connect to: %s", sb);
    }
}

