/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon.ops;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.catalog.lakehouse.paimon.PaimonConfig;
import org.apache.gravitino.catalog.lakehouse.paimon.ops.PaimonBackendCatalogWrapper;
import org.apache.gravitino.catalog.lakehouse.paimon.utils.CatalogUtils;
import org.apache.gravitino.catalog.lakehouse.paimon.utils.TableOpsUtils;
import org.apache.gravitino.rel.TableChange;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.Table;

public class PaimonCatalogOps
implements AutoCloseable {
    private final PaimonBackendCatalogWrapper paimonBackendCatalogWrapper;
    protected Catalog catalog;

    public PaimonCatalogOps(PaimonConfig paimonConfig) {
        this.paimonBackendCatalogWrapper = CatalogUtils.loadCatalogBackend(paimonConfig);
        Preconditions.checkArgument((this.paimonBackendCatalogWrapper.getCatalog() != null ? 1 : 0) != 0, (Object)"Can not load Paimon backend catalog instance.");
        this.catalog = this.paimonBackendCatalogWrapper.getCatalog();
    }

    @Override
    public void close() throws Exception {
        if (this.paimonBackendCatalogWrapper != null) {
            this.paimonBackendCatalogWrapper.close();
        }
    }

    public List<String> listDatabases() {
        return this.catalog.listDatabases();
    }

    public Map<String, String> loadDatabase(String databaseName) throws Catalog.DatabaseNotExistException {
        return this.catalog.loadDatabaseProperties(databaseName);
    }

    public void createDatabase(String databaseName, Map<String, String> properties) throws Catalog.DatabaseAlreadyExistException {
        this.catalog.createDatabase(databaseName, false, properties);
    }

    public void dropDatabase(String databaseName, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        this.catalog.dropDatabase(databaseName, false, cascade);
    }

    public List<String> listTables(String databaseName) throws Catalog.DatabaseNotExistException {
        return this.catalog.listTables(databaseName);
    }

    public Table loadTable(String tableName) throws Catalog.TableNotExistException {
        return this.catalog.getTable(this.tableIdentifier(tableName));
    }

    public void createTable(String tableName, Schema schema) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        this.catalog.createTable(this.tableIdentifier(tableName), schema, false);
    }

    public void purgeTable(String tableName) throws Catalog.TableNotExistException {
        this.catalog.dropTable(this.tableIdentifier(tableName), false);
    }

    public void alterTable(String tableName, TableChange ... changes) throws Catalog.ColumnAlreadyExistException, Catalog.TableNotExistException, Catalog.ColumnNotExistException {
        this.catalog.alterTable(this.tableIdentifier(tableName), TableOpsUtils.buildSchemaChanges(changes), false);
    }

    public void renameTable(String fromTableName, String toTableName) throws Catalog.TableNotExistException, Catalog.TableAlreadyExistException {
        this.catalog.renameTable(this.tableIdentifier(fromTableName), this.tableIdentifier(toTableName), false);
    }

    private Identifier tableIdentifier(String tableName) {
        return Identifier.fromString((String)tableName);
    }
}

