/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.TagMetadataObjectRelPO;
import org.apache.ibatis.annotations.Param;

public class TagMetadataObjectRelBaseSQLProvider {
    public String listTagPOsByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return "SELECT tm.tag_id as tagId, tm.tag_name as tagName, tm.metalake_id as metalakeId, tm.tag_comment as comment, tm.properties as properties, tm.audit_info as auditInfo, tm.current_version as currentVersion, tm.last_version as lastVersion, tm.deleted_at as deletedAt FROM tag_meta tm JOIN tag_relation_meta te ON tm.tag_id = te.tag_id WHERE te.metadata_object_id = #{metadataObjectId} AND te.metadata_object_type = #{metadataObjectType} AND te.deleted_at = 0 AND tm.deleted_at = 0";
    }

    public String getTagPOsByMetadataObjectAndTagName(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType, @Param(value="tagName") String tagName) {
        return "SELECT tm.tag_id as tagId, tm.tag_name as tagName, tm.metalake_id as metalakeId, tm.tag_comment as comment, tm.properties as properties, tm.audit_info as auditInfo, tm.current_version as currentVersion, tm.last_version as lastVersion, tm.deleted_at as deletedAt FROM tag_meta tm JOIN tag_relation_meta te ON tm.tag_id = te.tag_id WHERE te.metadata_object_id = #{metadataObjectId} AND te.metadata_object_type = #{metadataObjectType} AND tm.tag_name = #{tagName} AND te.deleted_at = 0 AND tm.deleted_at = 0";
    }

    public String listTagMetadataObjectRelsByMetalakeAndTagName(@Param(value="metalakeName") String metalakeName, @Param(value="tagName") String tagName) {
        return "SELECT te.tag_id as tagId, te.metadata_object_id as metadataObjectId, te.metadata_object_type as metadataObjectType, te.audit_info as auditInfo, te.current_version as currentVersion, te.last_version as lastVersion, te.deleted_at as deletedAt FROM tag_relation_meta te JOIN tag_meta tm JOIN metalake_meta mm ON te.tag_id = tm.tag_id AND tm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND tm.tag_name = #{tagName} AND te.deleted_at = 0 AND tm.deleted_at = 0 AND mm.deleted_at = 0";
    }

    public String batchInsertTagMetadataObjectRels(@Param(value="tagRels") List<TagMetadataObjectRelPO> tagRelPOs) {
        return "<script>INSERT INTO tag_relation_meta(tag_id, metadata_object_id, metadata_object_type, audit_info, current_version, last_version, deleted_at) VALUES <foreach collection='tagRels' item='item' separator=','>(#{item.tagId}, #{item.metadataObjectId}, #{item.metadataObjectType}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})</foreach></script>";
    }

    public String batchDeleteTagMetadataObjectRelsByTagIdsAndMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType, @Param(value="tagIds") List<Long> tagIds) {
        return "<script>UPDATE tag_relation_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE tag_id IN <foreach item='tagId' collection='tagIds' open='(' separator=',' close=')'>#{tagId}</foreach> And metadata_object_id = #{metadataObjectId} AND metadata_object_type = #{metadataObjectType} AND deleted_at = 0</script>";
    }

    public String softDeleteTagMetadataObjectRelsByMetalakeAndTagName(@Param(value="metalakeName") String metalakeName, @Param(value="tagName") String tagName) {
        return "UPDATE tag_relation_meta te SET te.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE te.tag_id IN (SELECT tm.tag_id FROM tag_meta tm WHERE tm.metalake_id IN (SELECT mm.metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND tm.tag_name = #{tagName} AND tm.deleted_at = 0) AND te.deleted_at = 0";
    }

    public String softDeleteTagMetadataObjectRelsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE tag_relation_meta te SET te.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE EXISTS (SELECT * FROM tag_meta tm WHERE tm.metalake_id = #{metalakeId} AND tm.tag_id = te.tag_id AND tm.deleted_at = 0) AND te.deleted_at = 0";
    }

    public String softDeleteTagMetadataObjectRelsByMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return " UPDATE tag_relation_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metadata_object_id = #{metadataObjectId} AND deleted_at = 0 AND metadata_object_type = #{metadataObjectType}";
    }

    public String softDeleteTagMetadataObjectRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return " UPDATE tag_relation_meta tmt SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE tmt.deleted_at = 0 AND EXISTS ( SELECT ct.catalog_id FROM catalog_meta ct WHERE ct.catalog_id = #{catalogId}  AND ct.catalog_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'CATALOG' UNION  SELECT st.catalog_id FROM schema_meta st WHERE st.catalog_id = #{catalogId} AND st.schema_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'SCHEMA' UNION  SELECT tt.catalog_id FROM topic_meta tt WHERE tt.catalog_id = #{catalogId} AND tt.topic_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TOPIC' UNION  SELECT tat.catalog_id FROM table_meta tat WHERE tat.catalog_id = #{catalogId} AND tat.table_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TABLE' UNION  SELECT ft.catalog_id FROM fileset_meta ft WHERE ft.catalog_id = #{catalogId}  AND ft.fileset_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'FILESET' UNION  SELECT cot.catalog_id FROM table_column_version_info cot WHERE cot.catalog_id = #{catalogId} AND cot.column_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'COLUMN' UNION  SELECT mt.catalog_id FROM model_meta mt WHERE mt.catalog_id = #{catalogId} AND mt.model_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'MODEL')";
    }

    public String softDeleteTagMetadataObjectRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return " UPDATE tag_relation_meta tmt SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE tmt.deleted_at = 0 AND EXISTS ( SELECT st.schema_id FROM schema_meta st WHERE st.schema_id = #{schemaId} AND  st.schema_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'SCHEMA' UNION  SELECT tt.schema_id FROM topic_meta tt WHERE tt.schema_id = #{schemaId} AND tt.topic_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TOPIC' UNION  SELECT tat.schema_id FROM table_meta tat WHERE tat.schema_id = #{schemaId} AND tat.table_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TABLE' UNION  SELECT ft.schema_id FROM fileset_meta ft WHERE ft.schema_id = #{schemaId} AND  ft.fileset_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'FILESET' UNION  SELECT cot.schema_id FROM table_column_version_info cot WHERE cot.schema_id = #{schemaId} AND  cot.column_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'COLUMN' UNION  SELECT mt.schema_id FROM model_meta mt WHERE mt.schema_id = #{schemaId} AND  mt.model_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'MODEL')";
    }

    public String softDeleteTagMetadataObjectRelsByTableId(@Param(value="tableId") Long tableId) {
        return " UPDATE tag_relation_meta tmt SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE tmt.deleted_at = 0 AND EXISTS ( SELECT tat.table_id FROM table_meta tat WHERE tat.table_id = #{tableId} AND  tat.table_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'TABLE' UNION  SELECT cot.table_id FROM table_column_version_info cot WHERE cot.table_id = #{tableId} AND cot.column_id = tmt.metadata_object_id AND tmt.metadata_object_type = 'COLUMN')";
    }

    public String deleteTagEntityRelsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM tag_relation_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

