/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.audit;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.audit.AuditLogWriter;
import org.apache.gravitino.audit.Formatter;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.listener.EventListenerManager;
import org.apache.gravitino.listener.api.EventListenerPlugin;
import org.apache.gravitino.listener.api.event.Event;
import org.apache.gravitino.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogManager {
    private static final Logger LOG = LoggerFactory.getLogger(AuditLogManager.class);
    @VisibleForTesting
    private AuditLogWriter auditLogWriter;

    public void init(Config config, EventListenerManager eventBusManager) {
        if (!config.get(Configs.AUDIT_LOG_ENABLED_CONF).booleanValue()) {
            LOG.info("Audit log is not enabled");
            return;
        }
        String formatterClassName = config.get(Configs.AUDIT_LOG_FORMATTER_CLASS_NAME);
        Formatter formatter = this.loadFormatter(formatterClassName);
        LOG.info("Audit log formatter class name:{}", (Object)formatterClassName);
        String writerClassName = config.get(Configs.AUDIT_LOG_WRITER_CLASS_NAME);
        this.auditLogWriter = this.loadAuditLogWriter(writerClassName, config.getConfigsWithPrefix("gravitino.audit.writer."), formatter);
        LOG.info("Audit log writer class name:{}", (Object)writerClassName);
        eventBusManager.addEventListener("audit-log", new EventListenerPlugin(){

            @Override
            public void init(Map<String, String> properties) throws RuntimeException {
            }

            @Override
            public void start() throws RuntimeException {
            }

            @Override
            public void stop() throws RuntimeException {
                try {
                    AuditLogManager.this.auditLogWriter.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void onPostEvent(Event event) throws RuntimeException {
                try {
                    AuditLogManager.this.auditLogWriter.write(event);
                }
                catch (Exception e) {
                    LOG.warn("Failed to write audit log {}.", (Object)event, (Object)e);
                }
            }

            @Override
            public EventListenerPlugin.Mode mode() {
                return EventListenerPlugin.Mode.ASYNC_ISOLATED;
            }
        });
    }

    private AuditLogWriter loadAuditLogWriter(String className, Map<String, String> config, Formatter formatter) {
        try {
            AuditLogWriter auditLogWriter = (AuditLogWriter)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map writerConfig = MapUtils.getPrefixMap(config, (String)(auditLogWriter.name() + "."));
            auditLogWriter.init(formatter, writerConfig);
            return auditLogWriter;
        }
        catch (Exception e) {
            throw new GravitinoRuntimeException((Throwable)e, "Failed to load audit log writer %s", new Object[]{className});
        }
    }

    private Formatter loadFormatter(String className) {
        try {
            return (Formatter)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new GravitinoRuntimeException((Throwable)e, "Failed to load formatter class name %s", new Object[]{className});
        }
    }

    AuditLogWriter getAuditLogWriter() {
        return this.auditLogWriter;
    }
}

