/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.MetadataObject;

public class MetadataObjects {
    public static final String METADATA_OBJECT_RESERVED_NAME = "*";
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private static final Joiner DOT_JOINER = Joiner.on('.');

    private MetadataObjects() {
    }

    public static MetadataObject of(String parent, String name, MetadataObject.Type type) {
        Preconditions.checkArgument(name != null, "Cannot create a metadata object with null name");
        Preconditions.checkArgument(type != null, "Cannot create a metadata object with no type");
        String fullName = parent == null ? name : DOT_JOINER.join(parent, name, new Object[0]);
        return MetadataObjects.parse(fullName, type);
    }

    public static MetadataObject of(List<String> names, MetadataObject.Type type) {
        Preconditions.checkArgument(names != null, "Cannot create a metadata object with null names");
        Preconditions.checkArgument(!names.isEmpty(), "Cannot create a metadata object with no names");
        Preconditions.checkArgument(names.size() <= 4, "Cannot create a metadata object with the name length which is greater than 4");
        Preconditions.checkArgument(type != null, "Cannot create a metadata object with no type");
        Preconditions.checkArgument(names.size() != 1 || type == MetadataObject.Type.CATALOG || type == MetadataObject.Type.METALAKE || type == MetadataObject.Type.ROLE, "If the length of names is 1, it must be the CATALOG, METALAKE, or ROLE type");
        Preconditions.checkArgument(names.size() != 2 || type == MetadataObject.Type.SCHEMA, "If the length of names is 2, it must be the SCHEMA type");
        Preconditions.checkArgument(names.size() != 3 || type == MetadataObject.Type.FILESET || type == MetadataObject.Type.TABLE || type == MetadataObject.Type.TOPIC || type == MetadataObject.Type.MODEL, "If the length of names is 3, it must be FILESET, TABLE, TOPIC or MODEL");
        Preconditions.checkArgument(names.size() != 4 || type == MetadataObject.Type.COLUMN, "If the length of names is 4, it must be COLUMN");
        for (String name : names) {
            MetadataObjects.checkName(name);
        }
        return new MetadataObjectImpl(MetadataObjects.getParentFullName(names), MetadataObjects.getLastName(names), type);
    }

    @Nullable
    public static MetadataObject parent(MetadataObject object) {
        MetadataObject.Type parentType;
        if (object == null) {
            return null;
        }
        if (object.type() == MetadataObject.Type.METALAKE || object.type() == MetadataObject.Type.CATALOG || object.type() == MetadataObject.Type.ROLE) {
            return null;
        }
        switch (object.type()) {
            case COLUMN: {
                parentType = MetadataObject.Type.TABLE;
                break;
            }
            case TABLE: 
            case FILESET: 
            case TOPIC: 
            case MODEL: {
                parentType = MetadataObject.Type.SCHEMA;
                break;
            }
            case SCHEMA: {
                parentType = MetadataObject.Type.CATALOG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected to reach here for metadata object type: " + (Object)((Object)object.type()));
            }
        }
        return MetadataObjects.parse(object.parent(), parentType);
    }

    public static MetadataObject parse(String fullName, MetadataObject.Type type) {
        Preconditions.checkArgument(StringUtils.isNotBlank(fullName), "Metadata object full name cannot be blank");
        List<String> parts = DOT_SPLITTER.splitToList(fullName);
        if (type == MetadataObject.Type.ROLE) {
            return MetadataObjects.of(Collections.singletonList(fullName), MetadataObject.Type.ROLE);
        }
        return MetadataObjects.of(parts, type);
    }

    private static String getParentFullName(List<String> names) {
        if (names.size() <= 1) {
            return null;
        }
        return DOT_JOINER.join(names.subList(0, names.size() - 1));
    }

    private static String getLastName(List<String> names) {
        return names.get(names.size() - 1);
    }

    private static void checkName(String name) {
        Preconditions.checkArgument(name != null, "Cannot create a metadata object with null name");
        Preconditions.checkArgument(!METADATA_OBJECT_RESERVED_NAME.equals(name), "Cannot create a metadata object with `*` name.");
    }

    public static class MetadataObjectImpl
    implements MetadataObject {
        private final String name;
        private final String parent;
        private final MetadataObject.Type type;

        public MetadataObjectImpl(String parent, String name, MetadataObject.Type type) {
            this.parent = parent;
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String parent() {
            return this.parent;
        }

        @Override
        public MetadataObject.Type type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MetadataObjectImpl)) {
                return false;
            }
            MetadataObjectImpl that = (MetadataObjectImpl)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.parent, this.type});
        }

        public String toString() {
            return "MetadataObject: [fullName=" + this.fullName() + "], [type=" + (Object)((Object)this.type) + "]";
        }
    }
}

