/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.Fileset;

public class CreateFileset
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String fileset;
    protected final String comment;
    protected final Map<String, String> properties;

    public CreateFileset(CommandContext context, String metalake, String catalog, String schema, String fileset, String comment, Map<String, String> properties) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.fileset = fileset;
        this.comment = comment;
        this.properties = properties;
    }

    @Override
    public void handle() {
        NameIdentifier name = NameIdentifier.of(this.schema, this.fileset);
        boolean managed = this.properties.get("managed").equals("true");
        String location = this.properties.get("location");
        Fileset.Type filesetType = managed ? Fileset.Type.MANAGED : Fileset.Type.EXTERNAL;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            client.loadCatalog(this.catalog).asFilesetCatalog().createFileset(name, this.comment, filesetType, location, null);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (FilesetAlreadyExistsException err) {
            this.exitWithError("Fileset already exists.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.fileset + " created");
    }
}

