/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class DeleteGroup
extends Command {
    protected final String metalake;
    protected final String group;
    protected final boolean force;

    public DeleteGroup(CommandContext context, String metalake, String group) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
        this.group = group;
    }

    @Override
    public void handle() {
        boolean deleted = false;
        if (!AreYouSure.really(this.force)) {
            return;
        }
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            deleted = client.removeGroup(this.group);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchGroupException err) {
            this.exitWithError("Unknown group.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (deleted) {
            this.printInformation(this.group + " deleted.");
        } else {
            this.printInformation(this.group + " not deleted.");
        }
    }
}

