/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;

public class DeleteSchema
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final boolean force;

    public DeleteSchema(CommandContext context, String metalake, String catalog, String schema) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
    }

    @Override
    public void handle() {
        boolean deleted = false;
        if (!AreYouSure.really(this.force)) {
            return;
        }
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            deleted = client.loadCatalog(this.catalog).asSchemas().dropSchema(this.schema, false);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (deleted) {
            this.printInformation(this.schema + " deleted.");
        } else {
            this.printInformation(this.schema + " not deleted.");
        }
    }
}

