/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import com.google.common.base.Joiner;
import java.util.Arrays;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ListTopics
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;

    public ListTopics(CommandContext context, String metalake, String catalog, String schema) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
    }

    @Override
    public void handle() {
        NameIdentifier[] topics = new NameIdentifier[]{};
        Namespace name = Namespace.of(this.schema);
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            topics = client.loadCatalog(this.catalog).asTopicCatalog().listTopics(name);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        String all = topics.length == 0 ? "No topics exist." : Joiner.on(",").join(Arrays.stream(topics).map(topic -> topic.name()).iterator());
        this.printResults(all);
    }
}

