/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.credential.ADLSTokenCredential;
import org.apache.gravitino.credential.AzureAccountKeyCredential;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.GCSTokenCredential;
import org.apache.gravitino.credential.OSSSecretKeyCredential;
import org.apache.gravitino.credential.OSSTokenCredential;
import org.apache.gravitino.credential.S3SecretKeyCredential;
import org.apache.gravitino.credential.S3TokenCredential;

public class CredentialPropertyUtils {
    @VisibleForTesting
    static final String ICEBERG_S3_ACCESS_KEY_ID = "s3.access-key-id";
    @VisibleForTesting
    static final String ICEBERG_S3_SECRET_ACCESS_KEY = "s3.secret-access-key";
    @VisibleForTesting
    static final String ICEBERG_S3_TOKEN = "s3.session-token";
    @VisibleForTesting
    static final String ICEBERG_GCS_TOKEN = "gcs.oauth2.token";
    @VisibleForTesting
    static final String ICEBERG_OSS_ACCESS_KEY_ID = "client.access-key-id";
    @VisibleForTesting
    static final String ICEBERG_OSS_ACCESS_KEY_SECRET = "client.access-key-secret";
    @VisibleForTesting
    static final String ICEBERG_OSS_SECURITY_TOKEN = "client.security-token";
    @VisibleForTesting
    static final String ICEBERG_ADLS_TOKEN = "adls.sas-token";
    @VisibleForTesting
    static final String ICEBERG_ADLS_ACCOUNT_NAME = "adls.auth.shared-key.account.name";
    @VisibleForTesting
    static final String ICEBERG_ADLS_ACCOUNT_KEY = "adls.auth.shared-key.account.key";
    private static Map<String, String> icebergCredentialPropertyMap = ImmutableMap.of("token", "gcs.oauth2.token", "s3-access-key-id", "s3.access-key-id", "s3-secret-access-key", "s3.secret-access-key", "s3-session-token", "s3.session-token", "oss-security-token", "client.security-token", "oss-access-key-id", "client.access-key-id", "oss-secret-access-key", "client.access-key-secret", "azure-storage-account-name", "adls.auth.shared-key.account.name", "azure-storage-account-key", "adls.auth.shared-key.account.key");

    public static Map<String, String> toIcebergProperties(Credential credential) {
        if (credential instanceof S3TokenCredential || credential instanceof S3SecretKeyCredential || credential instanceof OSSTokenCredential || credential instanceof OSSSecretKeyCredential || credential instanceof AzureAccountKeyCredential) {
            return CredentialPropertyUtils.transformProperties(credential.credentialInfo(), icebergCredentialPropertyMap);
        }
        if (credential instanceof GCSTokenCredential) {
            Map<String, String> icebergGCSCredentialProperties = CredentialPropertyUtils.transformProperties(credential.credentialInfo(), icebergCredentialPropertyMap);
            icebergGCSCredentialProperties.put("gcs.oauth2.token-expires-at", String.valueOf(credential.expireTimeInMs()));
            return icebergGCSCredentialProperties;
        }
        if (credential instanceof ADLSTokenCredential) {
            ADLSTokenCredential adlsCredential = (ADLSTokenCredential)credential;
            String sasTokenKey = String.format("%s.%s.%s", ICEBERG_ADLS_TOKEN, adlsCredential.accountName(), "dfs.core.windows.net");
            HashMap<String, String> icebergADLSCredentialProperties = new HashMap<String, String>();
            icebergADLSCredentialProperties.put(sasTokenKey, adlsCredential.sasToken());
            return icebergADLSCredentialProperties;
        }
        return credential.toProperties();
    }

    private static Map<String, String> transformProperties(Map<String, String> originProperties, Map<String, String> transformMap) {
        HashMap<String, String> properties = new HashMap<String, String>();
        originProperties.forEach((k, v) -> {
            if (transformMap.containsKey(k)) {
                properties.put((String)transformMap.get(k), (String)v);
            }
        });
        return properties;
    }
}

