/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.exceptions.NoSuchCredentialException;

public interface SupportsCredentials {
    public Credential[] getCredentials();

    default public Credential getCredential(String credentialType) throws NoSuchCredentialException {
        Preconditions.checkArgument(StringUtils.isNotBlank(credentialType), "Credential type should not be empty");
        Credential[] credentials = this.getCredentials();
        if (credentials.length == 0) {
            throw new NoSuchCredentialException("No credential found for the credential type: %s", credentialType);
        }
        List filteredCredentials = Arrays.stream(credentials).filter(credential -> credentialType.equals(credential.credentialType())).collect(Collectors.toList());
        if (filteredCredentials.isEmpty()) {
            throw new NoSuchCredentialException("No credential found for the credential type: %s", credentialType);
        }
        if (credentials.length > 1) {
            throw new IllegalStateException("Multiple credentials found for the credential type:" + credentialType);
        }
        return (Credential)filteredCredentials.get(0);
    }
}

