/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.rel.TableDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class TableResponse
extends BaseResponse {
    @JsonProperty(value="table")
    private final TableDTO table;

    public TableResponse(TableDTO table) {
        super(0);
        this.table = table;
    }

    public TableResponse() {
        this.table = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.table != null, "table must not be null");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.table.name()), "table 'name' must not be null and empty");
        Preconditions.checkArgument(this.table.columns() != null && this.table.columns().length > 0, "table 'columns' must not be null and empty");
        Preconditions.checkArgument(this.table.auditInfo() != null, "table 'audit' must not be null");
        Preconditions.checkArgument(this.table.partitioning() != null, "table 'partitions' must not be null");
    }

    public TableDTO getTable() {
        return this.table;
    }

    @Override
    public String toString() {
        return "TableResponse(table=" + this.getTable() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableResponse)) {
            return false;
        }
        TableResponse other = (TableResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TableDTO this$table = this.getTable();
        TableDTO other$table = other.getTable();
        return !(this$table == null ? other$table != null : !((Object)this$table).equals(other$table));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TableDTO $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        return result;
    }
}

