/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.ApplyDeletionVectorReader;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatKey;
import org.apache.paimon.format.FormatReaderContext;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.FileIndexSkipper;
import org.apache.paimon.io.FileRecordReader;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.EmptyRecordReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.schema.SchemaEvolutionUtil;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BulkFormatMapping;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Projection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFileSplitRead
implements SplitRead<InternalRow> {
    private static final Logger LOG = LoggerFactory.getLogger(RawFileSplitRead.class);
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final TableSchema schema;
    private final FileFormatDiscover formatDiscover;
    private final FileStorePathFactory pathFactory;
    private final Map<FormatKey, RawFileBulkFormatMapping> bulkFormatMappings;
    private final boolean fileIndexReadEnabled;
    private int[][] projection;
    @Nullable
    private List<Predicate> filters;

    public RawFileSplitRead(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType rowType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, boolean fileIndexReadEnabled) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schema = schema;
        this.formatDiscover = formatDiscover;
        this.pathFactory = pathFactory;
        this.bulkFormatMappings = new HashMap<FormatKey, RawFileBulkFormatMapping>();
        this.fileIndexReadEnabled = fileIndexReadEnabled;
        this.projection = Projection.range((int)0, (int)rowType.getFieldCount()).toNestedIndexes();
    }

    public RawFileSplitRead withProjection(int[][] projectedFields) {
        if (projectedFields != null) {
            this.projection = projectedFields;
        }
        return this;
    }

    public RawFileSplitRead withFilter(Predicate predicate) {
        if (predicate != null) {
            this.filters = PredicateBuilder.splitAnd((Predicate)predicate);
        }
        return this;
    }

    @Override
    public RecordReader<InternalRow> createReader(DataSplit split) throws IOException {
        DataFilePathFactory dataFilePathFactory = this.pathFactory.createDataFilePathFactory(split.partition(), split.bucket());
        ArrayList suppliers = new ArrayList();
        if (split.beforeFiles().size() > 0) {
            LOG.info("Ignore split before files: " + split.beforeFiles());
        }
        DeletionVector.Factory dvFactory = DeletionVector.factory(this.fileIO, split.dataFiles(), split.deletionFiles().orElse(null));
        for (DataFileMeta file : split.dataFiles()) {
            String formatIdentifier = DataFilePathFactory.formatIdentifier(file.fileName());
            RawFileBulkFormatMapping bulkFormatMapping = this.bulkFormatMappings.computeIfAbsent(new FormatKey(file.schemaId(), formatIdentifier), this::createBulkFormatMapping);
            BinaryRow partition = split.partition();
            suppliers.add(() -> this.createFileReader(partition, file, dataFilePathFactory, bulkFormatMapping, dvFactory));
        }
        return ConcatRecordReader.create(suppliers);
    }

    private RawFileBulkFormatMapping createBulkFormatMapping(FormatKey key) {
        Pair<int[], int[][]> partitionMapping;
        TableSchema tableSchema = this.schema;
        TableSchema dataSchema = key.schemaId == this.schema.id() ? this.schema : this.schemaManager.schema(key.schemaId);
        int[][] dataProjection = SchemaEvolutionUtil.createDataProjection(tableSchema.fields(), dataSchema.fields(), this.projection);
        IndexCastMapping indexCastMapping = SchemaEvolutionUtil.createIndexCastMapping(Projection.of((int[][])this.projection).toTopLevelIndexes(), tableSchema.fields(), Projection.of((int[][])dataProjection).toTopLevelIndexes(), dataSchema.fields());
        List<Predicate> dataFilters = this.schema.id() == key.schemaId ? this.filters : SchemaEvolutionUtil.createDataFilters(tableSchema.fields(), dataSchema.fields(), this.filters);
        Pair partitionPair = null;
        if (!dataSchema.partitionKeys().isEmpty() && (partitionMapping = PartitionUtils.constructPartitionMapping(dataSchema, dataProjection)) != null) {
            dataProjection = (int[][])partitionMapping.getRight();
            partitionPair = Pair.of((Object)partitionMapping.getLeft(), (Object)dataSchema.projectedLogicalRowType(dataSchema.partitionKeys()));
        }
        RowType projectedRowType = Projection.of((int[][])dataProjection).project(dataSchema.logicalRowType());
        return new RawFileBulkFormatMapping(indexCastMapping.getIndexMapping(), indexCastMapping.getCastMapping(), (Pair<int[], RowType>)partitionPair, this.formatDiscover.discover(key.format).createReaderFactory(projectedRowType, dataFilters), dataSchema, dataFilters);
    }

    private RecordReader<InternalRow> createFileReader(BinaryRow partition, DataFileMeta file, DataFilePathFactory dataFilePathFactory, RawFileBulkFormatMapping bulkFormatMapping, DeletionVector.Factory dvFactory) throws IOException {
        boolean skip;
        if (this.fileIndexReadEnabled && (skip = FileIndexSkipper.skip(this.fileIO, bulkFormatMapping.getDataSchema(), bulkFormatMapping.getDataFilters(), dataFilePathFactory, file))) {
            return new EmptyRecordReader();
        }
        FileRecordReader fileRecordReader = new FileRecordReader(bulkFormatMapping.getReaderFactory(), (FormatReaderFactory.Context)new FormatReaderContext(this.fileIO, dataFilePathFactory.toPath(file.fileName()), file.fileSize()), bulkFormatMapping.getIndexMapping(), bulkFormatMapping.getCastMapping(), PartitionUtils.create(bulkFormatMapping.getPartitionPair(), partition));
        Optional<DeletionVector> deletionVector = dvFactory.create(file.fileName());
        if (deletionVector.isPresent() && !deletionVector.get().isEmpty()) {
            return new ApplyDeletionVectorReader<InternalRow>(fileRecordReader, deletionVector.get());
        }
        return fileRecordReader;
    }

    private static class RawFileBulkFormatMapping
    extends BulkFormatMapping {
        private final TableSchema dataSchema;
        private final List<Predicate> dataFilters;

        public RawFileBulkFormatMapping(int[] indexMapping, CastFieldGetter[] castMapping, Pair<int[], RowType> partitionPair, FormatReaderFactory bulkFormat, TableSchema dataSchema, List<Predicate> dataFilters) {
            super(indexMapping, castMapping, partitionPair, bulkFormat);
            this.dataSchema = dataSchema;
            this.dataFilters = dataFilters;
        }

        public TableSchema getDataSchema() {
            return this.dataSchema;
        }

        public List<Predicate> getDataFilters() {
            return this.dataFilters;
        }
    }
}

