/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.FileDeletionBase;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDeletion
extends FileDeletionBase {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotDeletion.class);
    private int cachedTagIndex = -1;
    private final Map<BinaryRow, Map<Integer, Set<String>>> cachedTagDataFiles = new HashMap<BinaryRow, Map<Integer, Set<String>>>();

    public SnapshotDeletion(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler, StatsFileHandler statsFileHandler) {
        super(fileIO, pathFactory, manifestFile, manifestList, indexFileHandler, statsFileHandler);
    }

    @Override
    public void cleanUnusedDataFiles(Snapshot snapshot, Predicate<ManifestEntry> skipper) {
        this.cleanUnusedDataFiles(snapshot.deltaManifestList(), skipper);
    }

    public void cleanUnusedDataFiles(String manifestList, Predicate<ManifestEntry> skipper) {
        List<String> manifestFileNames = this.readManifestFileNames(this.tryReadManifestList(manifestList));
        HashMap<Path, Pair<ManifestEntry, List<Path>>> dataFileToDelete = new HashMap<Path, Pair<ManifestEntry, List<Path>>>();
        for (String manifest : manifestFileNames) {
            List<ManifestEntry> manifestEntries;
            try {
                manifestEntries = this.manifestFile.read(manifest);
            }
            catch (Exception e) {
                LOG.warn("Failed to read some manifest files. Cancel deletion.", (Throwable)e);
                return;
            }
            this.getDataFileToDelete(dataFileToDelete, manifestEntries);
        }
        this.doCleanUnusedDataFile(dataFileToDelete, skipper);
    }

    @Override
    public void cleanUnusedManifests(Snapshot snapshot, Set<String> skippingSet) {
        this.cleanUnusedManifests(snapshot, skippingSet, true);
    }

    private void getDataFileToDelete(Map<Path, Pair<ManifestEntry, List<Path>>> dataFileToDelete, List<ManifestEntry> dataFileEntries) {
        block4: for (ManifestEntry entry : dataFileEntries) {
            Path bucketPath = this.pathFactory.bucketPath(entry.partition(), entry.bucket());
            Path dataFilePath = new Path(bucketPath, entry.file().fileName());
            switch (entry.kind()) {
                case ADD: {
                    dataFileToDelete.remove(dataFilePath);
                    continue block4;
                }
                case DELETE: {
                    ArrayList<Path> extraFiles = new ArrayList<Path>(entry.file().extraFiles().size());
                    for (String file : entry.file().extraFiles()) {
                        extraFiles.add(new Path(bucketPath, file));
                    }
                    dataFileToDelete.put(dataFilePath, (Pair<ManifestEntry, List<Path>>)Pair.of((Object)entry, extraFiles));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown value kind " + entry.kind().name());
        }
    }

    private void doCleanUnusedDataFile(Map<Path, Pair<ManifestEntry, List<Path>>> dataFileToDelete, Predicate<ManifestEntry> skipper) {
        ArrayList actualDataFileToDelete = new ArrayList();
        dataFileToDelete.forEach((path, pair) -> {
            ManifestEntry entry = (ManifestEntry)pair.getLeft();
            if (!skipper.test(entry)) {
                actualDataFileToDelete.add(path);
                actualDataFileToDelete.addAll((Collection)pair.getRight());
                this.recordDeletionBuckets(entry);
            }
        });
        this.deleteFiles(actualDataFileToDelete, arg_0 -> ((FileIO)this.fileIO).deleteQuietly(arg_0));
    }

    @VisibleForTesting
    void cleanUnusedDataFile(List<ManifestEntry> dataFileLog) {
        HashMap<Path, Pair<ManifestEntry, List<Path>>> dataFileToDelete = new HashMap<Path, Pair<ManifestEntry, List<Path>>>();
        this.getDataFileToDelete(dataFileToDelete, dataFileLog);
        this.doCleanUnusedDataFile(dataFileToDelete, f -> false);
    }

    public void deleteAddedDataFiles(String manifestListName) {
        List<String> manifestFileNames = this.readManifestFileNames(this.tryReadManifestList(manifestListName));
        for (String file : manifestFileNames) {
            try {
                List<ManifestEntry> manifestEntries = this.manifestFile.read(file);
                this.deleteAddedDataFiles(manifestEntries);
            }
            catch (Exception e) {
                LOG.info("Failed to read manifest " + file + ". Ignore it.", (Throwable)e);
            }
        }
    }

    private void deleteAddedDataFiles(List<ManifestEntry> manifestEntries) {
        ArrayList<Path> dataFileToDelete = new ArrayList<Path>();
        for (ManifestEntry entry : manifestEntries) {
            if (entry.kind() != FileKind.ADD) continue;
            dataFileToDelete.add(new Path(this.pathFactory.bucketPath(entry.partition(), entry.bucket()), entry.file().fileName()));
            this.recordDeletionBuckets(entry);
        }
        this.deleteFiles(dataFileToDelete, arg_0 -> ((FileIO)this.fileIO).deleteQuietly(arg_0));
    }

    public Predicate<ManifestEntry> dataFileSkipper(List<Snapshot> taggedSnapshots, long expiringSnapshotId) throws Exception {
        int index = TagManager.findPreviousTag(taggedSnapshots, expiringSnapshotId);
        if (index >= 0 && this.cachedTagIndex != index) {
            this.cachedTagIndex = index;
            this.cachedTagDataFiles.clear();
            this.addMergedDataFiles(this.cachedTagDataFiles, taggedSnapshots.get(index));
        }
        return entry -> index >= 0 && this.containsDataFile(this.cachedTagDataFiles, (ManifestEntry)entry);
    }
}

