/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.SnapshotManager;

public class StatisticTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String STATISTICS = "statistics";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "snapshot_id", (DataType)new BigIntType(false)), new DataField(1, "schema_id", (DataType)new BigIntType(false)), new DataField(2, "mergedRecordCount", (DataType)new BigIntType(true)), new DataField(3, "mergedRecordSize", (DataType)new BigIntType(true)), new DataField(2, "colstat", (DataType)SerializationUtils.newStringType(true))));
    private final FileIO fileIO;
    private final Path location;
    private final FileStoreTable dataTable;

    public StatisticTable(FileIO fileIO, Path location, FileStoreTable dataTable) {
        this.fileIO = fileIO;
        this.location = location;
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.dataTable.name() + "$" + STATISTICS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("snapshot_id");
    }

    @Override
    public InnerTableScan newScan() {
        return new StatisticScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new StatisticRead(this.fileIO, this.dataTable);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new StatisticTable(this.fileIO, this.location, (FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private static class StatisticRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private int[][] projection;
        private final FileStoreTable dataTable;

        public StatisticRead(FileIO fileIO, FileStoreTable dataTable) {
            this.fileIO = fileIO;
            this.dataTable = dataTable;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof StatisticSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Statistics statistics = this.dataTable.statistics().get();
            Iterator<Statistics> statisticsIterator = Collections.singletonList(statistics).iterator();
            Iterator rows = Iterators.transform(statisticsIterator, this::toRow);
            if (this.projection != null) {
                rows = Iterators.transform((Iterator)rows, row -> ProjectedRow.from((int[][])this.projection).replaceRow(row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(Statistics statistics) {
            return GenericRow.of((Object[])new Object[]{statistics.snapshotId(), statistics.schemaId(), statistics.mergedRecordCount().getAsLong(), statistics.mergedRecordSize().getAsLong(), BinaryString.fromString((String)JsonSerdeUtil.toJson(statistics.colStats()))});
        }
    }

    private static class StatisticSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final long rowCount;
        private final Path location;

        private StatisticSplit(long rowCount, Path location) {
            this.location = location;
            this.rowCount = rowCount;
        }

        @Override
        public long rowCount() {
            return this.rowCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatisticSplit that = (StatisticSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class StatisticScan
    extends ReadOnceTableScan {
        private StatisticScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            long rowCount;
            try {
                rowCount = new SnapshotManager(StatisticTable.this.fileIO, StatisticTable.this.location).snapshotCount();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return () -> Collections.singletonList(new StatisticSplit(rowCount, StatisticTable.this.location));
        }
    }
}

