/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.tag.TagAutoCreation;
import org.apache.paimon.tag.TagTimeExpire;
import org.apache.paimon.tag.TagTimeExtractor;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class TagAutoManager {
    private final TagAutoCreation tagAutoCreation;
    private final TagTimeExpire tagTimeExpire;

    private TagAutoManager(TagAutoCreation tagAutoCreation, TagTimeExpire tagTimeExpire) {
        this.tagAutoCreation = tagAutoCreation;
        this.tagTimeExpire = tagTimeExpire;
    }

    public void run() {
        if (this.tagAutoCreation != null) {
            this.tagAutoCreation.run();
        }
        if (this.tagTimeExpire != null) {
            this.tagTimeExpire.run();
        }
    }

    public static TagAutoManager create(CoreOptions options, SnapshotManager snapshotManager, TagManager tagManager, TagDeletion tagDeletion, List<TagCallback> callbacks) {
        TagTimeExtractor extractor = TagTimeExtractor.createForAutoTag(options);
        return new TagAutoManager(extractor == null ? null : TagAutoCreation.create(options, snapshotManager, tagManager, tagDeletion, callbacks), TagTimeExpire.create(snapshotManager, tagManager, tagDeletion, callbacks));
    }

    public TagAutoCreation getTagAutoCreation() {
        return this.tagAutoCreation;
    }
}

