/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.FilesetMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.FilesetMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class FilesetMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, FilesetMetaBaseSQLProvider> FILESET_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new FilesetMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new FilesetMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new FilesetMetaPostgreSQLProvider());

    public static FilesetMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return FILESET_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String listFilesetPOsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return FilesetMetaSQLProviderFactory.getProvider().listFilesetPOsBySchemaId(schemaId);
    }

    public static String listFilesetPOsByFilesetIds(@Param(value="filesetIds") List<Long> filesetIds) {
        return FilesetMetaSQLProviderFactory.getProvider().listFilesetPOsByFilesetIds(filesetIds);
    }

    public static String selectFilesetIdBySchemaIdAndName(@Param(value="schemaId") Long schemaId, @Param(value="filesetName") String name) {
        return FilesetMetaSQLProviderFactory.getProvider().selectFilesetIdBySchemaIdAndName(schemaId, name);
    }

    public static String selectFilesetMetaBySchemaIdAndName(@Param(value="schemaId") Long schemaId, @Param(value="filesetName") String name) {
        return FilesetMetaSQLProviderFactory.getProvider().selectFilesetMetaBySchemaIdAndName(schemaId, name);
    }

    public static String selectFilesetMetaById(@Param(value="filesetId") Long filesetId) {
        return FilesetMetaSQLProviderFactory.getProvider().selectFilesetMetaById(filesetId);
    }

    public static String insertFilesetMeta(@Param(value="filesetMeta") FilesetPO filesetPO) {
        return FilesetMetaSQLProviderFactory.getProvider().insertFilesetMeta(filesetPO);
    }

    public static String insertFilesetMetaOnDuplicateKeyUpdate(@Param(value="filesetMeta") FilesetPO filesetPO) {
        return FilesetMetaSQLProviderFactory.getProvider().insertFilesetMetaOnDuplicateKeyUpdate(filesetPO);
    }

    public static String updateFilesetMeta(@Param(value="newFilesetMeta") FilesetPO newFilesetPO, @Param(value="oldFilesetMeta") FilesetPO oldFilesetPO) {
        return FilesetMetaSQLProviderFactory.getProvider().updateFilesetMeta(newFilesetPO, oldFilesetPO);
    }

    public static String softDeleteFilesetMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return FilesetMetaSQLProviderFactory.getProvider().softDeleteFilesetMetasByMetalakeId(metalakeId);
    }

    public static String softDeleteFilesetMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return FilesetMetaSQLProviderFactory.getProvider().softDeleteFilesetMetasByCatalogId(catalogId);
    }

    public static String softDeleteFilesetMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return FilesetMetaSQLProviderFactory.getProvider().softDeleteFilesetMetasBySchemaId(schemaId);
    }

    public String softDeleteFilesetMetasByFilesetId(@Param(value="filesetId") Long filesetId) {
        return FilesetMetaSQLProviderFactory.getProvider().softDeleteFilesetMetasByFilesetId(filesetId);
    }

    public String deleteFilesetMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return FilesetMetaSQLProviderFactory.getProvider().deleteFilesetMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class FilesetMetaH2Provider
    extends FilesetMetaBaseSQLProvider {
        FilesetMetaH2Provider() {
        }
    }

    static class FilesetMetaMySQLProvider
    extends FilesetMetaBaseSQLProvider {
        FilesetMetaMySQLProvider() {
        }
    }
}

