/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.model.ModelVersionChange;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=UpdateModelVersionComment.class, name="updateComment"), @JsonSubTypes.Type(value=SetModelVersionPropertyRequest.class, name="setProperty"), @JsonSubTypes.Type(value=RemoveModelVersionPropertyRequest.class, name="removeProperty"), @JsonSubTypes.Type(value=UpdateModelVersionUriRequest.class, name="updateUri"), @JsonSubTypes.Type(value=UpdateModelVersionAliasesRequest.class, name="updateAliases")})
public interface ModelVersionUpdateRequest
extends RESTRequest {
    public ModelVersionChange modelVersionChange();

    public static class UpdateModelVersionAliasesRequest
    implements ModelVersionUpdateRequest {
        @JsonProperty(value="aliasesToAdd")
        private final String[] aliasesToAdd;
        @JsonProperty(value="aliasesToRemove")
        private final String[] aliasesToRemove;

        @Override
        public ModelVersionChange modelVersionChange() {
            return ModelVersionChange.updateAliases((String[])this.aliasesToAdd, (String[])this.aliasesToRemove);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.aliasesToAdd != null || this.aliasesToRemove != null ? 1 : 0) != 0, (Object)"At least one of aliasesToAdd or aliasesToRemove must be non-null");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateModelVersionAliasesRequest)) {
                return false;
            }
            UpdateModelVersionAliasesRequest other = (UpdateModelVersionAliasesRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAliasesToAdd(), other.getAliasesToAdd())) {
                return false;
            }
            return Arrays.deepEquals(this.getAliasesToRemove(), other.getAliasesToRemove());
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateModelVersionAliasesRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getAliasesToAdd());
            result = result * 59 + Arrays.deepHashCode(this.getAliasesToRemove());
            return result;
        }

        public UpdateModelVersionAliasesRequest(String[] aliasesToAdd, String[] aliasesToRemove) {
            this.aliasesToAdd = aliasesToAdd;
            this.aliasesToRemove = aliasesToRemove;
        }

        public UpdateModelVersionAliasesRequest() {
            this.aliasesToAdd = null;
            this.aliasesToRemove = null;
        }

        public String toString() {
            return "ModelVersionUpdateRequest.UpdateModelVersionAliasesRequest(aliasesToAdd=" + Arrays.deepToString(this.getAliasesToAdd()) + ", aliasesToRemove=" + Arrays.deepToString(this.getAliasesToRemove()) + ")";
        }

        public String[] getAliasesToAdd() {
            return this.aliasesToAdd;
        }

        public String[] getAliasesToRemove() {
            return this.aliasesToRemove;
        }
    }

    public static class UpdateModelVersionUriRequest
    implements ModelVersionUpdateRequest {
        @JsonProperty(value="newUri")
        private final String newUri;

        @Override
        public ModelVersionChange modelVersionChange() {
            return ModelVersionChange.updateUri((String)this.newUri);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newUri), (Object)"\"newUri\" field is required and cannot be empty");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateModelVersionUriRequest)) {
                return false;
            }
            UpdateModelVersionUriRequest other = (UpdateModelVersionUriRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newUri = this.getNewUri();
            String other$newUri = other.getNewUri();
            return !(this$newUri == null ? other$newUri != null : !this$newUri.equals(other$newUri));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateModelVersionUriRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newUri = this.getNewUri();
            result = result * 59 + ($newUri == null ? 43 : $newUri.hashCode());
            return result;
        }

        public UpdateModelVersionUriRequest(String newUri) {
            this.newUri = newUri;
        }

        public UpdateModelVersionUriRequest() {
            this.newUri = null;
        }

        public String toString() {
            return "ModelVersionUpdateRequest.UpdateModelVersionUriRequest(newUri=" + this.getNewUri() + ")";
        }

        public String getNewUri() {
            return this.newUri;
        }
    }

    public static class RemoveModelVersionPropertyRequest
    implements ModelVersionUpdateRequest {
        @JsonProperty(value="property")
        private final String property;

        @Override
        public ModelVersionChange modelVersionChange() {
            return ModelVersionChange.removeProperty((String)this.property);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveModelVersionPropertyRequest)) {
                return false;
            }
            RemoveModelVersionPropertyRequest other = (RemoveModelVersionPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveModelVersionPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public RemoveModelVersionPropertyRequest(String property) {
            this.property = property;
        }

        public RemoveModelVersionPropertyRequest() {
            this.property = null;
        }

        public String toString() {
            return "ModelVersionUpdateRequest.RemoveModelVersionPropertyRequest(property=" + this.getProperty() + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class SetModelVersionPropertyRequest
    implements ModelVersionUpdateRequest {
        @JsonProperty(value="property")
        private final String property;
        @JsonProperty(value="value")
        private final String value;

        @Override
        public ModelVersionChange modelVersionChange() {
            return ModelVersionChange.setProperty((String)this.property, (String)this.value);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
            Preconditions.checkArgument((this.value != null ? 1 : 0) != 0, (Object)"\"value\" field is required and cannot be null");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetModelVersionPropertyRequest)) {
                return false;
            }
            SetModelVersionPropertyRequest other = (SetModelVersionPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetModelVersionPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public SetModelVersionPropertyRequest(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public SetModelVersionPropertyRequest() {
            this.property = null;
            this.value = null;
        }

        public String toString() {
            return "ModelVersionUpdateRequest.SetModelVersionPropertyRequest(property=" + this.getProperty() + ", value=" + this.getValue() + ")";
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UpdateModelVersionComment
    implements ModelVersionUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        @Override
        public ModelVersionChange modelVersionChange() {
            return ModelVersionChange.updateComment((String)this.newComment);
        }

        @Override
        public void validate() throws IllegalArgumentException {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateModelVersionComment)) {
                return false;
            }
            UpdateModelVersionComment other = (UpdateModelVersionComment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateModelVersionComment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public UpdateModelVersionComment(String newComment) {
            this.newComment = newComment;
        }

        public UpdateModelVersionComment() {
            this.newComment = null;
        }

        public String toString() {
            return "ModelVersionUpdateRequest.UpdateModelVersionComment(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }
}

