/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.doris.operation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.doris.DorisCatalog;
import org.apache.gravitino.catalog.doris.operation.DorisTablePartitionOperations;
import org.apache.gravitino.catalog.doris.utils.DorisUtils;
import org.apache.gravitino.catalog.jdbc.JdbcColumn;
import org.apache.gravitino.catalog.jdbc.JdbcTable;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTableOperations;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTablePartitionOperations;
import org.apache.gravitino.connector.BaseColumn;
import org.apache.gravitino.connector.PropertyEntry;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Strategy;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.partitions.Partition;

public class DorisTableOperations
extends JdbcTableOperations {
    private static final String BACK_QUOTE = "`";
    private static final String DORIS_AUTO_INCREMENT = "AUTO_INCREMENT";
    private static final String NEW_LINE = "\n";

    public JdbcTablePartitionOperations createJdbcTablePartitionOperations(JdbcTable loadedTable) {
        return new DorisTablePartitionOperations(this.dataSource, loadedTable, this.exceptionMapper, this.typeConverter);
    }

    protected String generateCreateTableSql(String tableName, JdbcColumn[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, Index[] indexes) {
        DorisTableOperations.validateIncrementCol(columns);
        DorisTableOperations.validateDistribution(distribution, columns);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(String.format("CREATE TABLE `%s` (", tableName)).append(NEW_LINE);
        sqlBuilder.append(Arrays.stream(columns).map(column -> {
            StringBuilder columnsSql = new StringBuilder();
            columnsSql.append(" ").append(BACK_QUOTE).append(column.name()).append(BACK_QUOTE);
            this.appendColumnDefinition((JdbcColumn)column, columnsSql);
            return columnsSql.toString();
        }).collect(Collectors.joining(",\n")));
        DorisTableOperations.appendIndexesSql(indexes, sqlBuilder);
        sqlBuilder.append(NEW_LINE).append(")");
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            sqlBuilder.append(" COMMENT \"").append(comment).append("\"");
        }
        DorisTableOperations.appendPartitionSql(partitioning, columns, sqlBuilder);
        if (distribution.strategy() == Strategy.HASH) {
            sqlBuilder.append(NEW_LINE).append(" DISTRIBUTED BY HASH(");
            sqlBuilder.append(Arrays.stream(distribution.expressions()).map(column -> BACK_QUOTE + column.toString() + BACK_QUOTE).collect(Collectors.joining(", ")));
            sqlBuilder.append(")");
        } else if (distribution.strategy() == Strategy.EVEN) {
            sqlBuilder.append(NEW_LINE).append(" DISTRIBUTED BY ").append("RANDOM");
        }
        if (distribution.number() != 0) {
            sqlBuilder.append(" BUCKETS ").append(distribution.number());
        }
        properties = this.appendNecessaryProperties(properties);
        sqlBuilder.append(NEW_LINE).append(DorisUtils.generatePropertiesSql(properties));
        String result = sqlBuilder.toString();
        LOG.info("Generated create table:{} sql: {}", (Object)tableName, (Object)result);
        return result;
    }

    private Map<String, String> appendNecessaryProperties(Map<String, String> properties) {
        HashMap<Object, Object> resultMap = properties == null ? new HashMap() : new HashMap<String, String>(properties);
        if (!resultMap.containsKey("replication_num")) {
            String query = "show backends";
            try (Connection connection = this.dataSource.getConnection();
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(query);){
                int backendCount = 0;
                while (resultSet.next()) {
                    String alive = resultSet.getString("Alive");
                    if (!"true".equalsIgnoreCase(alive)) continue;
                    ++backendCount;
                }
                if (backendCount < 3) {
                    resultMap.put("replication_num", ((PropertyEntry)DorisCatalog.DORIS_TABLE_PROPERTIES_META.propertyEntries().get("replication_num")).getDefaultValue().toString());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get the number of backend servers", e);
            }
        }
        return resultMap;
    }

    private static void validateIncrementCol(JdbcColumn[] columns) {
        List autoIncrementCols = Arrays.stream(columns).filter(Column::autoIncrement).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)autoIncrementCols.isEmpty(), (Object)"Doris does not support auto-increment column");
    }

    private static void validateDistribution(Distribution distribution, JdbcColumn[] columns) {
        Preconditions.checkArgument((null != distribution ? 1 : 0) != 0, (Object)"Doris must set distribution");
        Preconditions.checkArgument((Strategy.HASH == distribution.strategy() || Strategy.EVEN == distribution.strategy() ? 1 : 0) != 0, (Object)"Doris only supports HASH or EVEN(RANDOM) distribution strategy");
        if (distribution.strategy() == Strategy.HASH) {
            Arrays.stream(distribution.expressions()).forEach(expression -> Preconditions.checkArgument((boolean)Arrays.stream(columns).anyMatch(column -> column.name().equalsIgnoreCase(expression.toString())), (Object)("Distribution column " + expression + " does not exist in the table columns")));
        } else if (distribution.strategy() == Strategy.EVEN) {
            Preconditions.checkArgument((distribution.expressions().length == 0 ? 1 : 0) != 0, (Object)"Doris does not support distribution column in EVEN distribution strategy");
        }
    }

    private static void appendIndexesSql(Index[] indexes, StringBuilder sqlBuilder) {
        if (indexes.length == 0) {
            return;
        }
        Arrays.stream(indexes).forEach(index -> {
            if (index.fieldNames().length > 1) {
                throw new IllegalArgumentException("Index does not support multi fields in Doris");
            }
        });
        String indexSql = Arrays.stream(indexes).map(index -> String.format("INDEX %s (%s)", index.name(), index.fieldNames()[0][0])).collect(Collectors.joining(",\n"));
        sqlBuilder.append(",").append(NEW_LINE).append(indexSql);
    }

    private static void appendPartitionSql(Transform[] partitioning, JdbcColumn[] columns, StringBuilder sqlBuilder) {
        StringBuilder partitionSqlBuilder;
        if (ArrayUtils.isEmpty((Object[])partitioning)) {
            return;
        }
        Preconditions.checkArgument((partitioning.length == 1 ? 1 : 0) != 0, (Object)"Composite partition type is not supported");
        Set<String> columnNames = Arrays.stream(columns).map(BaseColumn::name).collect(Collectors.toSet());
        if (partitioning[0] instanceof Transforms.RangeTransform) {
            Transforms.RangeTransform rangePartition = (Transforms.RangeTransform)partitioning[0];
            partitionSqlBuilder = DorisTableOperations.generateRangePartitionSql(rangePartition, columnNames);
        } else if (partitioning[0] instanceof Transforms.ListTransform) {
            Transforms.ListTransform listPartition = (Transforms.ListTransform)partitioning[0];
            partitionSqlBuilder = DorisTableOperations.generateListPartitionSql(listPartition, columnNames);
        } else {
            throw new IllegalArgumentException("Unsupported partition type of Doris");
        }
        sqlBuilder.append((CharSequence)partitionSqlBuilder);
    }

    private static StringBuilder generateRangePartitionSql(Transforms.RangeTransform rangePartition, Set<String> columnNames) {
        Preconditions.checkArgument((rangePartition.fieldName().length == 1 ? 1 : 0) != 0, (Object)"Doris partition does not support nested field");
        Preconditions.checkArgument((boolean)columnNames.contains(rangePartition.fieldName()[0]), (Object)"The partition field must be one of the columns");
        StringBuilder partitionSqlBuilder = new StringBuilder(NEW_LINE);
        String partitionDefinition = String.format(" PARTITION BY RANGE(`%s`)", rangePartition.fieldName()[0]);
        partitionSqlBuilder.append(partitionDefinition).append(NEW_LINE).append("(");
        Object[] assignments = rangePartition.assignments();
        if (!ArrayUtils.isEmpty((Object[])assignments)) {
            String partitionSqlFragments = Arrays.stream(assignments).map(DorisUtils::generatePartitionSqlFragment).collect(Collectors.joining(",\n"));
            partitionSqlBuilder.append(NEW_LINE).append(partitionSqlFragments);
        }
        partitionSqlBuilder.append(NEW_LINE).append(")");
        return partitionSqlBuilder;
    }

    private static StringBuilder generateListPartitionSql(Transforms.ListTransform listPartition, Set<String> columnNames) {
        String[][] filedNames;
        ImmutableList.Builder partitionColumnsBuilder = ImmutableList.builder();
        for (String[] filedName : filedNames = listPartition.fieldNames()) {
            Preconditions.checkArgument((filedName.length == 1 ? 1 : 0) != 0, (Object)"Doris partition does not support nested field");
            Preconditions.checkArgument((boolean)columnNames.contains(filedName[0]), (Object)"The partition field must be one of the columns");
            partitionColumnsBuilder.add((Object)(BACK_QUOTE + filedName[0] + BACK_QUOTE));
        }
        String partitionColumns = partitionColumnsBuilder.build().stream().collect(Collectors.joining(","));
        StringBuilder partitionSqlBuilder = new StringBuilder(NEW_LINE);
        String partitionDefinition = String.format(" PARTITION BY LIST(%s)", partitionColumns);
        partitionSqlBuilder.append(partitionDefinition).append(NEW_LINE).append("(");
        Object[] assignments = listPartition.assignments();
        if (!ArrayUtils.isEmpty((Object[])assignments)) {
            ImmutableList.Builder partitions = ImmutableList.builder();
            for (Object part : assignments) {
                Literal[][] lists = part.lists();
                Preconditions.checkArgument((lists.length > 0 ? 1 : 0) != 0, (Object)"The number of values in list partition must be greater than 0");
                Preconditions.checkArgument((boolean)Arrays.stream(lists).allMatch(p -> ((Literal[])p).length == filedNames.length), (Object)"The number of partitioning columns must be consistent");
                partitions.add((Object)DorisUtils.generatePartitionSqlFragment((Partition)part));
            }
            partitionSqlBuilder.append(NEW_LINE).append(partitions.build().stream().collect(Collectors.joining(",\n")));
        }
        partitionSqlBuilder.append(NEW_LINE).append(")");
        return partitionSqlBuilder;
    }

    protected boolean getAutoIncrementInfo(ResultSet resultSet) throws SQLException {
        return "YES".equalsIgnoreCase(resultSet.getString("IS_AUTOINCREMENT"));
    }

    protected Map<String, String> getTableProperties(Connection connection, String tableName) throws SQLException {
        String showCreateTableSQL = String.format("SHOW CREATE TABLE `%s`", tableName);
        StringBuilder createTableSqlSb = new StringBuilder();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(showCreateTableSQL);){
            while (resultSet.next()) {
                createTableSqlSb.append(resultSet.getString("Create Table"));
            }
        }
        String createTableSql = createTableSqlSb.toString();
        if (StringUtils.isEmpty((CharSequence)createTableSql)) {
            throw new NoSuchTableException("Table %s does not exist in %s.", new Object[]{tableName, connection.getCatalog()});
        }
        return Collections.unmodifiableMap(DorisUtils.extractPropertiesFromSql(createTableSql));
    }

    /*
     * Exception decompiling
     */
    protected List<Index> getIndexes(Connection connection, String databaseName, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected Transform[] getTablePartitioning(Connection connection, String databaseName, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void correctJdbcTableFields(Connection connection, String databaseName, String tableName, JdbcTable.Builder tableBuilder) throws SQLException {
        if (StringUtils.isNotEmpty((CharSequence)tableBuilder.comment())) {
            return;
        }
        StringBuilder comment = new StringBuilder();
        String sql = "SELECT TABLE_COMMENT FROM information_schema.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, databaseName);
            preparedStatement.setString(2, tableName);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    comment.append(resultSet.getString("TABLE_COMMENT"));
                }
            }
            tableBuilder.withComment(comment.toString());
        }
        catch (SQLException e) {
            throw this.exceptionMapper.toGravitinoException(e);
        }
        this.getTableStatus(connection, databaseName, tableName);
    }

    protected void getTableStatus(Connection connection, String databaseName, String tableName) {
        String sql = String.format("SHOW ALTER TABLE COLUMN WHERE TableName = '%s' ORDER BY JobId DESC limit 1", tableName);
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            StringBuilder jobStatus = new StringBuilder();
            while (resultSet.next()) {
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    jobStatus.append(resultSet.getMetaData().getColumnName(i)).append(" : ").append(resultSet.getString(i)).append(", ");
                }
                jobStatus.append(" | ");
            }
            if (jobStatus.length() > 0) {
                LOG.info("Table {}.{} schema-change execution status: {}", new Object[]{databaseName, tableName, jobStatus});
            }
        }
        catch (SQLException e) {
            throw this.exceptionMapper.toGravitinoException(e);
        }
    }

    protected String generateRenameTableSql(String oldTableName, String newTableName) {
        return String.format("ALTER TABLE `%s` RENAME `%s`", oldTableName, newTableName);
    }

    protected String generatePurgeTableSql(String tableName) {
        throw new UnsupportedOperationException("Doris does not support purge table in Gravitino, please use drop table");
    }

    protected String generateAlterTableSql(String databaseName, String tableName, TableChange ... changes) {
        JdbcTable lazyLoadTable = null;
        TableChange.UpdateComment updateComment = null;
        ArrayList<TableChange.SetProperty> setProperties = new ArrayList<TableChange.SetProperty>();
        ArrayList<String> alterSql = new ArrayList<String>();
        for (int i = 0; i < changes.length; ++i) {
            TableChange change = changes[i];
            if (change instanceof TableChange.UpdateComment) {
                updateComment = (TableChange.UpdateComment)change;
                continue;
            }
            if (change instanceof TableChange.SetProperty) {
                setProperties.add((TableChange.SetProperty)change);
                continue;
            }
            if (change instanceof TableChange.RemoveProperty) {
                throw new IllegalArgumentException("Remove property is not supported yet");
            }
            if (change instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)change;
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.addColumnFieldDefinition(addColumn));
                continue;
            }
            if (change instanceof TableChange.RenameColumn) {
                throw new IllegalArgumentException("Rename column is not supported yet");
            }
            if (change instanceof TableChange.UpdateColumnType) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)change;
                alterSql.add(this.updateColumnTypeFieldDefinition(updateColumnType, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnComment) {
                TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)change;
                alterSql.add(this.updateColumnCommentFieldDefinition(updateColumnComment));
                continue;
            }
            if (change instanceof TableChange.UpdateColumnPosition) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                TableChange.UpdateColumnPosition updateColumnPosition = (TableChange.UpdateColumnPosition)change;
                alterSql.add(this.updateColumnPositionFieldDefinition(updateColumnPosition, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.DeleteColumn) {
                TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)change;
                String deleteColSql = this.deleteColumnFieldDefinition(deleteColumn, lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable));
                if (!StringUtils.isNotEmpty((CharSequence)deleteColSql)) continue;
                alterSql.add(deleteColSql);
                continue;
            }
            if (change instanceof TableChange.UpdateColumnNullability) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(this.updateColumnNullabilityDefinition((TableChange.UpdateColumnNullability)change, lazyLoadTable));
                continue;
            }
            if (change instanceof TableChange.AddIndex) {
                alterSql.add(DorisTableOperations.addIndexDefinition((TableChange.AddIndex)change));
                continue;
            }
            if (change instanceof TableChange.DeleteIndex) {
                lazyLoadTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable);
                alterSql.add(DorisTableOperations.deleteIndexDefinition(lazyLoadTable, (TableChange.DeleteIndex)change));
                continue;
            }
            throw new IllegalArgumentException("Unsupported table change type: " + change.getClass().getName());
        }
        if (!setProperties.isEmpty()) {
            alterSql.add(this.generateTableProperties(setProperties));
        }
        if (null != updateComment) {
            JdbcTable jdbcTable;
            StringIdentifier identifier;
            String newComment = updateComment.getNewComment();
            if (null == StringIdentifier.fromComment((String)newComment) && null != (identifier = StringIdentifier.fromComment((String)(jdbcTable = this.getOrCreateTable(databaseName, tableName, lazyLoadTable)).comment()))) {
                newComment = StringIdentifier.addToComment((StringIdentifier)identifier, (String)newComment);
            }
            alterSql.add("MODIFY COMMENT \"" + newComment + "\"");
        }
        if (CollectionUtils.isEmpty(alterSql)) {
            return "";
        }
        String result = "ALTER TABLE `" + tableName + "`\n" + String.join((CharSequence)",\n", alterSql) + ";";
        LOG.info("Generated alter table:{} sql: {}", (Object)(databaseName + "." + tableName), (Object)result);
        return result;
    }

    private String updateColumnNullabilityDefinition(TableChange.UpdateColumnNullability change, JdbcTable table) {
        this.validateUpdateColumnNullable(change, table);
        String col = change.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(table, col);
        JdbcColumn updateColumn = (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(col)).withDefaultValue(column.defaultValue())).withNullable(change.nullable())).withType(column.dataType())).withComment(column.comment())).withAutoIncrement(column.autoIncrement())).build();
        return "MODIFY COLUMN `" + col + BACK_QUOTE + this.appendColumnDefinition(updateColumn, new StringBuilder());
    }

    private String generateTableProperties(List<TableChange.SetProperty> setProperties) {
        String properties = setProperties.stream().map(setProperty -> String.format("\"%s\" = \"%s\"", setProperty.getProperty(), setProperty.getValue())).collect(Collectors.joining(",\n"));
        return "set (" + properties + ")";
    }

    private String updateColumnCommentFieldDefinition(TableChange.UpdateColumnComment updateColumnComment) {
        String newComment = updateColumnComment.getNewComment();
        if (updateColumnComment.fieldName().length > 1) {
            throw new UnsupportedOperationException("Doris does not support nested column names.");
        }
        String col = updateColumnComment.fieldName()[0];
        return String.format("MODIFY COLUMN `%s` COMMENT '%s'", col, newComment);
    }

    private String addColumnFieldDefinition(TableChange.AddColumn addColumn) {
        String dataType = (String)this.typeConverter.fromGravitino(addColumn.getDataType());
        if (addColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException("Doris does not support nested column names.");
        }
        String col = addColumn.fieldName()[0];
        StringBuilder columnDefinition = new StringBuilder();
        columnDefinition.append("ADD COLUMN ").append(BACK_QUOTE).append(col).append(BACK_QUOTE).append(" ").append(dataType).append(" ");
        if (!addColumn.isNullable()) {
            columnDefinition.append("NOT NULL ");
        }
        if (StringUtils.isNotEmpty((CharSequence)addColumn.getComment())) {
            columnDefinition.append("COMMENT '").append(addColumn.getComment()).append("' ");
        }
        if (addColumn.getPosition() instanceof TableChange.First) {
            columnDefinition.append("FIRST");
        } else if (addColumn.getPosition() instanceof TableChange.After) {
            TableChange.After afterPosition = (TableChange.After)addColumn.getPosition();
            columnDefinition.append("AFTER ").append(BACK_QUOTE).append(afterPosition.getColumn()).append(BACK_QUOTE);
        } else if (!(addColumn.getPosition() instanceof TableChange.Default)) {
            throw new IllegalArgumentException("Invalid column position.");
        }
        return columnDefinition.toString();
    }

    private String updateColumnPositionFieldDefinition(TableChange.UpdateColumnPosition updateColumnPosition, JdbcTable jdbcTable) {
        if (updateColumnPosition.fieldName().length > 1) {
            throw new UnsupportedOperationException("Doris does not support nested column names.");
        }
        String col = updateColumnPosition.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(jdbcTable, col);
        StringBuilder columnDefinition = new StringBuilder();
        columnDefinition.append("MODIFY COLUMN ").append(BACK_QUOTE).append(col).append(BACK_QUOTE);
        this.appendColumnDefinition(column, columnDefinition);
        if (updateColumnPosition.getPosition() instanceof TableChange.First) {
            columnDefinition.append("FIRST");
        } else if (updateColumnPosition.getPosition() instanceof TableChange.After) {
            TableChange.After afterPosition = (TableChange.After)updateColumnPosition.getPosition();
            columnDefinition.append("AFTER ").append(BACK_QUOTE).append(afterPosition.getColumn()).append(BACK_QUOTE);
        } else {
            Arrays.stream(jdbcTable.columns()).reduce((column1, column2) -> column2).map(Column::name).ifPresent(s -> columnDefinition.append("AFTER ").append((String)s));
        }
        return columnDefinition.toString();
    }

    private String deleteColumnFieldDefinition(TableChange.DeleteColumn deleteColumn, JdbcTable jdbcTable) {
        if (deleteColumn.fieldName().length > 1) {
            throw new UnsupportedOperationException("Doris does not support nested column names.");
        }
        String col = deleteColumn.fieldName()[0];
        boolean colExists = true;
        try {
            this.getJdbcColumnFromTable(jdbcTable, col);
        }
        catch (NoSuchColumnException noSuchColumnException) {
            colExists = false;
        }
        if (!colExists) {
            if (BooleanUtils.isTrue((Boolean)deleteColumn.getIfExists())) {
                return "";
            }
            throw new IllegalArgumentException("Delete column does not exist: " + col);
        }
        return "DROP COLUMN `" + col + BACK_QUOTE;
    }

    private String updateColumnTypeFieldDefinition(TableChange.UpdateColumnType updateColumnType, JdbcTable jdbcTable) {
        if (updateColumnType.fieldName().length > 1) {
            throw new UnsupportedOperationException("Doris does not support nested column names.");
        }
        String col = updateColumnType.fieldName()[0];
        JdbcColumn column = this.getJdbcColumnFromTable(jdbcTable, col);
        StringBuilder sqlBuilder = new StringBuilder("MODIFY COLUMN `" + col + BACK_QUOTE);
        JdbcColumn newColumn = (JdbcColumn)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)((JdbcColumn.Builder)JdbcColumn.builder().withName(col)).withType(updateColumnType.getNewDataType())).withComment(column.comment())).withDefaultValue(Column.DEFAULT_VALUE_NOT_SET)).withNullable(column.nullable())).withAutoIncrement(column.autoIncrement())).build();
        return this.appendColumnDefinition(newColumn, sqlBuilder).toString();
    }

    private StringBuilder appendColumnDefinition(JdbcColumn column, StringBuilder sqlBuilder) {
        sqlBuilder.append(" ").append((String)this.typeConverter.fromGravitino(column.dataType())).append(" ");
        if (column.nullable()) {
            sqlBuilder.append("NULL ");
        } else {
            sqlBuilder.append("NOT NULL ");
        }
        if (!Column.DEFAULT_VALUE_NOT_SET.equals(column.defaultValue())) {
            sqlBuilder.append("DEFAULT ").append(this.columnDefaultValueConverter.fromGravitino(column.defaultValue())).append(" ");
        }
        if (column.autoIncrement()) {
            sqlBuilder.append(DORIS_AUTO_INCREMENT).append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)column.comment())) {
            sqlBuilder.append("COMMENT '").append(column.comment()).append("' ");
        }
        return sqlBuilder;
    }

    static String addIndexDefinition(TableChange.AddIndex addIndex) {
        return String.format("ADD INDEX %s (%s)", addIndex.getName(), addIndex.getFieldNames()[0][0]);
    }

    static String deleteIndexDefinition(JdbcTable lazyLoadTable, TableChange.DeleteIndex deleteIndex) {
        if (!deleteIndex.isIfExists()) {
            Preconditions.checkArgument((boolean)Arrays.stream(lazyLoadTable.index()).anyMatch(index -> index.name().equals(deleteIndex.getName())), (Object)"Index does not exist");
        }
        return "DROP INDEX " + deleteIndex.getName();
    }

    /*
     * Exception decompiling
     */
    protected Distribution getDistributionInfo(Connection connection, String databaseName, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Transform[] lambda$getTablePartitioning$7(Transform t) {
        return new Transform[]{t};
    }
}

