/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseContentScanTask;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.MergeableScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

abstract class BaseChangelogContentScanTask<ThisT extends ContentScanTask<F> & ChangelogScanTask, F extends ContentFile<F>>
extends BaseContentScanTask<ThisT, F>
implements ChangelogScanTask {
    private final int changeOrdinal;
    private final long commitSnapshotId;

    BaseChangelogContentScanTask(int changeOrdinal, long commitSnapshotId, F file, String schemaString, String specString, ResidualEvaluator residuals) {
        super(file, schemaString, specString, residuals);
        this.changeOrdinal = changeOrdinal;
        this.commitSnapshotId = commitSnapshotId;
    }

    public int changeOrdinal() {
        return this.changeOrdinal;
    }

    public long commitSnapshotId() {
        return this.commitSnapshotId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("change_ordinal", this.changeOrdinal).add("commit_snapshot_id", this.commitSnapshotId).add("file", (Object)this.file().path()).add("partition_data", (Object)this.file().partition()).add("residual", (Object)this.residual()).toString();
    }

    static abstract class SplitScanTask<ThisT, ParentT extends ContentScanTask<F> & ChangelogScanTask, F extends ContentFile<F>>
    implements ContentScanTask<F>,
    ChangelogScanTask,
    MergeableScanTask<ThisT> {
        private final ParentT parentTask;
        private final long offset;
        private final long length;

        protected SplitScanTask(ParentT parentTask, long offset, long length) {
            this.parentTask = parentTask;
            this.offset = offset;
            this.length = length;
        }

        protected abstract ThisT copyWithNewLength(long var1);

        protected ParentT parentTask() {
            return this.parentTask;
        }

        public int changeOrdinal() {
            return ((ChangelogScanTask)this.parentTask).changeOrdinal();
        }

        public long commitSnapshotId() {
            return ((ChangelogScanTask)this.parentTask).commitSnapshotId();
        }

        public F file() {
            return (F)this.parentTask.file();
        }

        public PartitionSpec spec() {
            return this.parentTask.spec();
        }

        public long start() {
            return this.offset;
        }

        public long length() {
            return this.length;
        }

        public Expression residual() {
            return this.parentTask.residual();
        }

        public boolean canMerge(ScanTask other) {
            if (this.getClass().equals(other.getClass())) {
                SplitScanTask that = (SplitScanTask)other;
                return this.changeOrdinal() == that.changeOrdinal() && this.commitSnapshotId() == that.commitSnapshotId() && this.file().equals(that.file()) && this.start() + this.length() == that.start();
            }
            return false;
        }

        public ThisT merge(ScanTask other) {
            SplitScanTask that = (SplitScanTask)other;
            return this.copyWithNewLength(this.length() + that.length());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("change_ordinal", this.changeOrdinal()).add("commit_snapshot_id", this.commitSnapshotId()).add("file", (Object)this.file().path()).add("partition_data", (Object)this.file().partition()).add("offset", this.offset).add("length", this.length).add("residual", (Object)this.residual()).toString();
        }
    }
}

