/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.gravitino.storage.relational.po.FilesetVersionPO;

public class FilesetPO {
    private Long filesetId;
    private String filesetName;
    private Long metalakeId;
    private Long catalogId;
    private Long schemaId;
    private String type;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;
    private List<FilesetVersionPO> filesetVersionPOs;

    public Long getFilesetId() {
        return this.filesetId;
    }

    public String getFilesetName() {
        return this.filesetName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getCatalogId() {
        return this.catalogId;
    }

    public Long getSchemaId() {
        return this.schemaId;
    }

    public String getType() {
        return this.type;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public List<FilesetVersionPO> getFilesetVersionPOs() {
        return this.filesetVersionPOs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilesetPO)) {
            return false;
        }
        FilesetPO filesetPO = (FilesetPO)o;
        return Objects.equal((Object)this.getFilesetId(), (Object)filesetPO.getFilesetId()) && Objects.equal((Object)this.getFilesetName(), (Object)filesetPO.getFilesetName()) && Objects.equal((Object)this.getMetalakeId(), (Object)filesetPO.getMetalakeId()) && Objects.equal((Object)this.getCatalogId(), (Object)filesetPO.getCatalogId()) && Objects.equal((Object)this.getSchemaId(), (Object)filesetPO.getSchemaId()) && Objects.equal((Object)this.getType(), (Object)filesetPO.getType()) && Objects.equal((Object)this.getAuditInfo(), (Object)filesetPO.getAuditInfo()) && Objects.equal((Object)this.getCurrentVersion(), (Object)filesetPO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)filesetPO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)filesetPO.getDeletedAt()) && Objects.equal(this.getFilesetVersionPOs(), filesetPO.getFilesetVersionPOs());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getFilesetId(), this.getFilesetName(), this.getMetalakeId(), this.getCatalogId(), this.getSchemaId(), this.getType(), this.getAuditInfo(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt(), this.getFilesetVersionPOs()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final FilesetPO filesetPO = new FilesetPO();

        private Builder() {
        }

        public Builder withFilesetId(Long filesetId) {
            this.filesetPO.filesetId = filesetId;
            return this;
        }

        public Builder withFilesetName(String filesetName) {
            this.filesetPO.filesetName = filesetName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.filesetPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withCatalogId(Long catalogId) {
            this.filesetPO.catalogId = catalogId;
            return this;
        }

        public Builder withSchemaId(Long schemaId) {
            this.filesetPO.schemaId = schemaId;
            return this;
        }

        public Builder withType(String type) {
            this.filesetPO.type = type;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.filesetPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.filesetPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.filesetPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.filesetPO.deletedAt = deletedAt;
            return this;
        }

        public Builder withFilesetVersionPOs(List<FilesetVersionPO> filesetVersionPOs) {
            this.filesetPO.filesetVersionPOs = filesetVersionPOs;
            return this;
        }

        public Long getFilesetMetalakeId() {
            Preconditions.checkState((this.filesetPO.getMetalakeId() != null ? 1 : 0) != 0, (Object)"Metalake id is null");
            return this.filesetPO.getMetalakeId();
        }

        public Long getFilesetCatalogId() {
            Preconditions.checkState((this.filesetPO.getCatalogId() != null ? 1 : 0) != 0, (Object)"Catalog id is null");
            return this.filesetPO.getCatalogId();
        }

        public Long getFilesetSchemaId() {
            Preconditions.checkState((this.filesetPO.getSchemaId() != null ? 1 : 0) != 0, (Object)"Schema id is null");
            return this.filesetPO.getSchemaId();
        }

        private void validate() {
            Preconditions.checkArgument((this.filesetPO.filesetId != null ? 1 : 0) != 0, (Object)"Fileset id is required");
            Preconditions.checkArgument((this.filesetPO.filesetName != null ? 1 : 0) != 0, (Object)"Fileset name is required");
            Preconditions.checkArgument((this.filesetPO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.filesetPO.catalogId != null ? 1 : 0) != 0, (Object)"Catalog id is required");
            Preconditions.checkArgument((this.filesetPO.schemaId != null ? 1 : 0) != 0, (Object)"Schema id is required");
            Preconditions.checkArgument((this.filesetPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.filesetPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.filesetPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.filesetPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
            Preconditions.checkArgument((this.filesetPO.filesetVersionPOs != null && !this.filesetPO.filesetVersionPOs.isEmpty() ? 1 : 0) != 0, (Object)"Fileset version is required");
        }

        public FilesetPO build() {
            this.validate();
            return this.filesetPO;
        }
    }
}

