/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.dataset.namespace.resolver;

import io.openlineage.client.dataset.namespace.resolver.DatasetNamespaceResolver;
import io.openlineage.client.dataset.namespace.resolver.PatternMatchingGroupNamespaceResolverConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PatternMatchingGroupNamespaceResolver
implements DatasetNamespaceResolver {
    private final String matchingGroup;
    private final Pattern pattern;
    private final String schema;

    public PatternMatchingGroupNamespaceResolver(PatternMatchingGroupNamespaceResolverConfig config) {
        this.matchingGroup = config.getMatchingGroup();
        this.pattern = Pattern.compile(config.getRegex());
        this.schema = config.getSchema();
    }

    @Override
    public String resolve(String namespace) {
        if (StringUtils.isNotEmpty((CharSequence)this.schema) && !namespace.startsWith(this.schema + "://")) {
            return namespace;
        }
        Matcher matcher = this.pattern.matcher(namespace);
        if (matcher.find()) {
            return matcher.replaceAll(matcher.group(this.matchingGroup));
        }
        return namespace;
    }
}

