/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Types;

public interface ManifestFile {
    public static final Types.NestedField PATH = Types.NestedField.required(500, "manifest_path", Types.StringType.get(), "Location URI with FS scheme");
    public static final Types.NestedField LENGTH = Types.NestedField.required(501, "manifest_length", Types.LongType.get(), "Total file size in bytes");
    public static final Types.NestedField SPEC_ID = Types.NestedField.required(502, "partition_spec_id", Types.IntegerType.get(), "Spec ID used to write");
    public static final Types.NestedField MANIFEST_CONTENT = Types.NestedField.optional(517, "content", Types.IntegerType.get(), "Contents of the manifest: 0=data, 1=deletes");
    public static final Types.NestedField SEQUENCE_NUMBER = Types.NestedField.optional(515, "sequence_number", Types.LongType.get(), "Sequence number when the manifest was added");
    public static final Types.NestedField MIN_SEQUENCE_NUMBER = Types.NestedField.optional(516, "min_sequence_number", Types.LongType.get(), "Lowest sequence number in the manifest");
    public static final Types.NestedField SNAPSHOT_ID = Types.NestedField.optional(503, "added_snapshot_id", Types.LongType.get(), "Snapshot ID that added the manifest");
    public static final Types.NestedField ADDED_FILES_COUNT = Types.NestedField.optional(504, "added_files_count", Types.IntegerType.get(), "Added entry count");
    public static final Types.NestedField EXISTING_FILES_COUNT = Types.NestedField.optional(505, "existing_files_count", Types.IntegerType.get(), "Existing entry count");
    public static final Types.NestedField DELETED_FILES_COUNT = Types.NestedField.optional(506, "deleted_files_count", Types.IntegerType.get(), "Deleted entry count");
    public static final Types.NestedField ADDED_ROWS_COUNT = Types.NestedField.optional(512, "added_rows_count", Types.LongType.get(), "Added rows count");
    public static final Types.NestedField EXISTING_ROWS_COUNT = Types.NestedField.optional(513, "existing_rows_count", Types.LongType.get(), "Existing rows count");
    public static final Types.NestedField DELETED_ROWS_COUNT = Types.NestedField.optional(514, "deleted_rows_count", Types.LongType.get(), "Deleted rows count");
    public static final Types.StructType PARTITION_SUMMARY_TYPE = Types.StructType.of(Types.NestedField.required(509, "contains_null", Types.BooleanType.get(), "True if any file has a null partition value"), Types.NestedField.optional(518, "contains_nan", Types.BooleanType.get(), "True if any file has a nan partition value"), Types.NestedField.optional(510, "lower_bound", Types.BinaryType.get(), "Partition lower bound for all files"), Types.NestedField.optional(511, "upper_bound", Types.BinaryType.get(), "Partition upper bound for all files"));
    public static final Types.NestedField PARTITION_SUMMARIES = Types.NestedField.optional(507, "partitions", Types.ListType.ofRequired(508, PARTITION_SUMMARY_TYPE), "Summary for each partition");
    public static final Types.NestedField KEY_METADATA = Types.NestedField.optional(519, "key_metadata", Types.BinaryType.get(), "Encryption key metadata blob");
    public static final Schema SCHEMA = new Schema(PATH, LENGTH, SPEC_ID, MANIFEST_CONTENT, SEQUENCE_NUMBER, MIN_SEQUENCE_NUMBER, SNAPSHOT_ID, ADDED_FILES_COUNT, EXISTING_FILES_COUNT, DELETED_FILES_COUNT, ADDED_ROWS_COUNT, EXISTING_ROWS_COUNT, DELETED_ROWS_COUNT, PARTITION_SUMMARIES, KEY_METADATA);

    public static Schema schema() {
        return SCHEMA;
    }

    public String path();

    public long length();

    public int partitionSpecId();

    public ManifestContent content();

    public long sequenceNumber();

    public long minSequenceNumber();

    public Long snapshotId();

    default public boolean hasAddedFiles() {
        return this.addedFilesCount() == null || this.addedFilesCount() > 0;
    }

    public Integer addedFilesCount();

    public Long addedRowsCount();

    default public boolean hasExistingFiles() {
        return this.existingFilesCount() == null || this.existingFilesCount() > 0;
    }

    public Integer existingFilesCount();

    public Long existingRowsCount();

    default public boolean hasDeletedFiles() {
        return this.deletedFilesCount() == null || this.deletedFilesCount() > 0;
    }

    public Integer deletedFilesCount();

    public Long deletedRowsCount();

    public List<PartitionFieldSummary> partitions();

    default public ByteBuffer keyMetadata() {
        return null;
    }

    public ManifestFile copy();

    public static interface PartitionFieldSummary {
        public static Types.StructType getType() {
            return PARTITION_SUMMARY_TYPE;
        }

        public boolean containsNull();

        default public Boolean containsNaN() {
            return null;
        }

        public ByteBuffer lowerBound();

        public ByteBuffer upperBound();

        public PartitionFieldSummary copy();
    }
}

