/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.metadata.GravitinoColumn;

public class GravitinoTable {
    private final String schemaName;
    private final String tableName;
    private final List<GravitinoColumn> columns;
    private final String comment;
    private final Map<String, String> properties;
    private SortOrder[] sortOrders = new SortOrder[0];
    private Transform[] partitioning = new Transform[0];
    private Distribution distribution = Distributions.NONE;

    @JsonCreator
    public GravitinoTable(String schemaName, String tableName, Table tableMetadata) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        ImmutableList.Builder tableColumns = ImmutableList.builder();
        for (int i = 0; i < tableMetadata.columns().length; ++i) {
            tableColumns.add((Object)new GravitinoColumn(tableMetadata.columns()[i], i));
        }
        this.columns = tableColumns.build();
        this.comment = tableMetadata.comment();
        this.properties = tableMetadata.properties();
        this.sortOrders = tableMetadata.sortOrder();
        this.partitioning = tableMetadata.partitioning();
        this.distribution = tableMetadata.distribution();
    }

    public GravitinoTable(String schemaName, String tableName, List<GravitinoColumn> columns, String comment, Map<String, String> properties) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columns = columns;
        this.comment = comment;
        this.properties = properties;
    }

    public GravitinoTable(String schemaName, String tableName, Column[] columns, String comment, Map<String, String> properties) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        ImmutableList.Builder tableColumns = ImmutableList.builder();
        for (int i = 0; i < columns.length; ++i) {
            tableColumns.add((Object)new GravitinoColumn(columns[i], i));
        }
        this.columns = tableColumns.build();
        this.comment = comment;
        this.properties = properties;
    }

    public String getName() {
        return this.tableName;
    }

    public List<GravitinoColumn> getColumns() {
        return this.columns;
    }

    public Column[] getRawColumns() {
        Column[] gravitinoColumns = new Column[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            GravitinoColumn column = this.columns.get(i);
            gravitinoColumns[i] = Column.of((String)column.getName(), (Type)column.getType(), (String)column.getComment(), (boolean)column.isNullable(), (boolean)column.isAutoIncrement(), null);
        }
        return gravitinoColumns;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public GravitinoColumn getColumn(String columName) {
        Optional<GravitinoColumn> entry = this.columns.stream().filter(column -> column.getName().equals(columName)).findFirst();
        if (entry.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_COLUMN_NOT_EXISTS, String.format("Column `%s` does not exist", columName));
        }
        return entry.get();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setSortOrders(SortOrder[] sortOrders) {
        this.sortOrders = sortOrders;
    }

    public void setPartitioning(Transform[] partitioning) {
        this.partitioning = partitioning;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    public SortOrder[] getSortOrders() {
        return this.sortOrders;
    }

    public Transform[] getPartitioning() {
        return this.partitioning;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }
}

