/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.client.MetadataObjectCredentialOperations;
import org.apache.gravitino.client.MetadataObjectRoleOperations;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.SupportsCredentials;
import org.apache.gravitino.dto.file.FilesetDTO;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.shaded.com.google.common.collect.Lists;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

class GenericFileset
implements Fileset,
SupportsTags,
SupportsRoles,
SupportsCredentials {
    private final FilesetDTO filesetDTO;
    private final MetadataObjectTagOperations objectTagOperations;
    private final MetadataObjectRoleOperations objectRoleOperations;
    private final MetadataObjectCredentialOperations objectCredentialOperations;

    GenericFileset(FilesetDTO filesetDTO, RESTClient restClient, Namespace filesetNs) {
        this.filesetDTO = filesetDTO;
        ArrayList<String> filesetFullName = Lists.newArrayList(filesetNs.level(1), filesetNs.level(2), filesetDTO.name());
        MetadataObject filesetObject = MetadataObjects.of(filesetFullName, MetadataObject.Type.FILESET);
        this.objectTagOperations = new MetadataObjectTagOperations(filesetNs.level(0), filesetObject, restClient);
        this.objectRoleOperations = new MetadataObjectRoleOperations(filesetNs.level(0), filesetObject, restClient);
        this.objectCredentialOperations = new MetadataObjectCredentialOperations(filesetNs.level(0), filesetObject, restClient);
    }

    @Override
    public Audit auditInfo() {
        return this.filesetDTO.auditInfo();
    }

    @Override
    public String name() {
        return this.filesetDTO.name();
    }

    @Override
    @Nullable
    public String comment() {
        return this.filesetDTO.comment();
    }

    @Override
    public Fileset.Type type() {
        return this.filesetDTO.type();
    }

    @Override
    public Map<String, String> storageLocations() {
        return this.filesetDTO.storageLocations();
    }

    @Override
    public Map<String, String> properties() {
        return this.filesetDTO.properties();
    }

    @Override
    public SupportsTags supportsTags() {
        return this;
    }

    @Override
    public SupportsRoles supportsRoles() {
        return this;
    }

    @Override
    public SupportsCredentials supportsCredentials() {
        return this;
    }

    @Override
    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    @Override
    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    @Override
    public Tag getTag(String name) throws NoSuchTagException {
        return this.objectTagOperations.getTag(name);
    }

    @Override
    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }

    @Override
    public String[] listBindingRoleNames() {
        return this.objectRoleOperations.listBindingRoleNames();
    }

    @Override
    public Credential[] getCredentials() {
        return this.objectCredentialOperations.getCredentials();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericFileset)) {
            return false;
        }
        GenericFileset that = (GenericFileset)obj;
        return this.filesetDTO.equals(that.filesetDTO);
    }

    public int hashCode() {
        return this.filesetDTO.hashCode();
    }
}

