/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.shaded.com.google.common.base.Joiner;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableSortedSet;
import org.apache.gravitino.shaded.com.google.common.collect.Lists;

@Evolving
public interface ModelVersionChange {
    public static final Joiner COMMA_JOINER = Joiner.on(",").skipNulls();

    public static ModelVersionChange updateComment(String newComment) {
        return new UpdateComment(newComment);
    }

    public static ModelVersionChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static ModelVersionChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static ModelVersionChange updateUri(String newUri) {
        return new UpdateUri(newUri);
    }

    public static ModelVersionChange updateAliases(String[] aliasesToAdd, String[] aliasesToRemove) {
        String[] toAdd = aliasesToAdd == null ? new String[]{} : aliasesToAdd;
        String[] toRemove = aliasesToRemove == null ? new String[]{} : aliasesToRemove;
        return new UpdateAliases(Arrays.stream(toAdd).collect(Collectors.toList()), Arrays.stream(toRemove).collect(Collectors.toList()));
    }

    public static final class UpdateAliases
    implements ModelVersionChange {
        private final ImmutableSortedSet<String> aliasesToAdd;
        private final ImmutableSortedSet<String> aliasesToRemove;

        public UpdateAliases(List<String> aliasesToAdd, List<String> aliasesToRemove) {
            this.aliasesToAdd = ImmutableSortedSet.copyOf(aliasesToAdd != null ? aliasesToAdd : Lists.newArrayList());
            this.aliasesToRemove = ImmutableSortedSet.copyOf(aliasesToRemove != null ? aliasesToRemove : Lists.newArrayList());
        }

        public Set<String> aliasesToAdd() {
            return this.aliasesToAdd;
        }

        public Set<String> aliasesToRemove() {
            return this.aliasesToRemove;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UpdateAliases)) {
                return false;
            }
            UpdateAliases that = (UpdateAliases)o;
            return this.aliasesToAdd.equals(that.aliasesToAdd) && this.aliasesToRemove.equals(that.aliasesToRemove);
        }

        public int hashCode() {
            return Objects.hash(this.aliasesToAdd, this.aliasesToRemove);
        }

        public String toString() {
            return "UpdateAlias AliasToAdd: (" + COMMA_JOINER.join(this.aliasesToAdd) + ") AliasToRemove: (" + COMMA_JOINER.join(this.aliasesToRemove) + ")";
        }
    }

    public static final class UpdateUri
    implements ModelVersionChange {
        private final String newUri;

        public UpdateUri(String newUri) {
            this.newUri = newUri;
        }

        public String newUri() {
            return this.newUri;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof UpdateUri)) {
                return false;
            }
            UpdateUri other = (UpdateUri)obj;
            return Objects.equals(this.newUri, other.newUri);
        }

        public int hashCode() {
            return Objects.hash(this.newUri);
        }

        public String toString() {
            return "UpdateUri " + this.newUri;
        }
    }

    public static final class RemoveProperty
    implements ModelVersionChange {
        private final String property;

        public RemoveProperty(String property) {
            this.property = property;
        }

        public String property() {
            return this.property;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RemoveProperty)) {
                return false;
            }
            RemoveProperty other = (RemoveProperty)obj;
            return Objects.equals(this.property, other.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }

        public String toString() {
            return "REMOVEPROPERTY " + this.property;
        }
    }

    public static final class SetProperty
    implements ModelVersionChange {
        private final String property;
        private final String value;

        public SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String property() {
            return this.property;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SetProperty)) {
                return false;
            }
            SetProperty other = (SetProperty)obj;
            return Objects.equals(this.property, other.property) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }

        public String toString() {
            return "SETPROPERTY " + this.property + " " + this.value;
        }
    }

    public static final class UpdateComment
    implements ModelVersionChange {
        private final String newComment;

        public UpdateComment(String newComment) {
            this.newComment = newComment;
        }

        public String newComment() {
            return this.newComment;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof UpdateComment)) {
                return false;
            }
            UpdateComment other = (UpdateComment)obj;
            return Objects.equals(this.newComment, other.newComment);
        }

        public int hashCode() {
            return Objects.hash(this.newComment);
        }

        public String toString() {
            return "UpdateComment " + this.newComment;
        }
    }
}

